/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.web.conditions.GlobalCreateRepositoryPermissionCondition;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationComparator;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.RepositoryOption;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={GlobalCreateRepositoryPermissionCondition.class})
public class ConvertLocalToGlobalRepository
extends ConfigureRepository {
    @Autowired
    private VcsRepositoryConfigurationComparator vcsRepositoryConfigurationComparator;
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    private long selectedRepository = 0L;

    public String input() {
        this.validatePlan();
        if (this.repositoryDefinition == null) {
            this.addActionError(this.getText("repository.edit.error.missingConfiguration"));
            return "error";
        }
        if (this.hasErrors()) {
            return "error";
        }
        this.repositoryName = this.repositoryDefinition.getName();
        this.userDescription = this.repositoryDefinition.getDescription();
        this.validateName();
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        try {
            if (this.selectedRepository != 0L) {
                VcsRepositoryData linkedRepository = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(this.selectedRepository);
                Plan plan = this.getMutablePlan();
                this.vcsRepositoryConfigurationService.setParentOfPlanRepository((ImmutablePlan)plan, this.repositoryDefinition.getId(), this.selectedRepository);
                this.vcsRepositoryConfigurationService.editRepository(plan, this.repositoryDefinition.getId(), (PartialVcsRepositoryData)PartialVcsRepositoryDataImpl.createChild((VcsRepositoryData)linkedRepository));
            } else {
                this.vcsRepositoryConfigurationService.shareRepository(this.getMutablePlan(), this.repositoryDefinition, this.repositoryName, this.userDescription, this.getUser());
            }
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        return "success";
    }

    public void validate() {
        this.validatePlan();
        if (this.repositoryDefinition == null) {
            this.addActionError(this.getText("repository.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.repositoryId})));
        }
        if (this.selectedRepository != 0L) {
            RepositoryDataEntity existingRepositoryData = this.repositoryDefinitionManager.getRepositoryDataEntity(this.selectedRepository);
            if (existingRepositoryData == null) {
                this.addActionError(this.getText("repository.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.selectedRepository})));
            }
        } else {
            this.validateName();
            this.validateUsageProjectSharedCredentials();
        }
    }

    @NotNull
    public List<RepositoryOption> getRepositoriesForConvertion() {
        String groupName = this.getText("repository.shared.convert.useExisting");
        ArrayList<RepositoryOption> repositoryOptions = new ArrayList<RepositoryOption>();
        repositoryOptions.add(new RepositoryOption(this.getText("repository.shared.convert.createNew"), ""));
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(this.getImmutablePlan());
        if (this.repositoryDefinition != null) {
            this.repositoryDefinitionManager.getLinkedRepositories().stream().filter(vcsRepositoryData -> this.vcsRepositoryConfigurationComparator.isTheSameBranch(this.vcsRepositoryModuleDescriptor, variableSubstitutor, this.repositoryDefinition.getCompleteData(), vcsRepositoryData)).map(vcsRepositoryData -> new RepositoryOption((VcsRepositoryData)vcsRepositoryData, groupName, true)).forEach(repositoryOptions::add);
        }
        return repositoryOptions;
    }

    @Override
    protected void validateName() {
        this.checkFieldXssSafety("repositoryName", this.repositoryName);
        if (StringUtils.isBlank((CharSequence)this.repositoryName)) {
            this.addFieldError("repositoryName", this.getText("repository.name.not.set"));
        } else if (this.vcsRepositoryConfigurationService.validateLinkedRepositoryName(this.repositoryName, (BambooIdProvider)this.repositoryDefinition.getCompleteData())) {
            this.addFieldError("repositoryName", this.getText("repository.shared.name.already.exists"));
        }
    }

    private void validateUsageProjectSharedCredentials() {
        Set projectSharedCredentialsForRepository = this.vcsRepositoryConfigurationService.getProjectSharedCredentialsForRepository(this.repositoryDefinition);
        if (!projectSharedCredentialsForRepository.isEmpty()) {
            this.addActionError(this.getText("repository.shared.convert.uses.project.shared.credentials"));
        }
    }

    public void setSelectedRepository(long selectedRepository) {
        this.selectedRepository = selectedRepository;
    }
}

