/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PermissionFilteringRepositoryDefinitionAccessor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.Lists;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.Preparable;
import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureRepository
extends BuildConfigurationSupport
implements PlanEditSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(ConfigureRepository.class);
    protected String SELECTED_REPOSITORY = "selectedRepository";
    protected boolean saved;
    protected PartialVcsRepositoryData repositoryDefinition;
    protected String selectedRepository;
    protected String selectedWebRepositoryViewer;
    protected String repositoryName;
    protected Long repositoryId;
    protected String userDescription;
    @Inject
    protected CustomVariableContext customVariableContext;
    @Inject
    protected VariableSubstitutorFactory variableSubstitutorFactory;
    @Inject
    protected VcsRepositoryManager vcsRepositoryManager;
    @Inject
    protected VcsUIConfigBean vcsUIConfigBean;
    @Inject
    protected VcsViewerUIConfigBean vcsViewerUIConfigBean;
    @Inject
    protected VcsConfigurationHelper vcsConfigurationHelper;
    @Inject
    protected PermissionFilteringRepositoryDefinitionAccessor cachedRepositoryDefinitionAccessor;
    protected VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor;

    public void prepare() throws Exception {
        if (this.repositoryId == null) {
            this.repositoryId = 0L;
        } else if (this.repositoryId > 0L) {
            this.repositoryDefinition = this.getRepositoryById(this.repositoryId);
        }
        this.selectedWebRepositoryViewer = "none:none";
        if (this.repositoryDefinition != null) {
            this.selectedRepository = this.repositoryDefinition.isLinked() ? Long.toString(this.repositoryId) : this.repositoryDefinition.getPluginKey();
            this.repositoryName = this.repositoryDefinition.getName();
            this.userDescription = this.repositoryDefinition.getDescription();
            this.vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.repositoryDefinition.getPluginKey());
            String string = this.selectedWebRepositoryViewer = this.repositoryDefinition.getViewerConfiguration() != null ? this.repositoryDefinition.getViewerConfiguration().getPluginKey() : VcsViewerUIConfigBean.NO_VIEWER.getKey();
        }
        if (this.vcsRepositoryModuleDescriptor == null && !StringUtils.isBlank((CharSequence)this.selectedRepository) && !StringUtils.isNumeric((CharSequence)this.selectedRepository)) {
            this.vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.selectedRepository);
            if (this.repositoryDefinition == null && this.vcsRepositoryModuleDescriptor != null) {
                this.selectedWebRepositoryViewer = this.vcsRepositoryModuleDescriptor.getDefaultVcsViewerKey();
            }
        }
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        if (this.repositoryDefinition != null) {
            JSONObject jsonRepositoryObject = new JSONObject();
            jsonRepositoryObject.put("id", this.repositoryDefinition.getId());
            jsonRepositoryObject.put("name", (Object)this.repositoryDefinition.getName());
            jsonRepositoryObject.put("description", (Object)this.repositoryDefinition.getDescription());
            jsonRepositoryObject.put("global", this.repositoryDefinition.isLinked());
            jsonObject.put("repositoryResult", (Object)jsonRepositoryObject);
        }
        return jsonObject;
    }

    @Nullable
    protected PartialVcsRepositoryData getRepositoryById(long id) {
        return this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(id);
    }

    protected void validatePlan() {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError(this.getText("repository.plan.noPlan"));
        } else if (!PlanClassHelper.isChain((ImmutablePlan)plan)) {
            this.addActionError(this.getText("repository.plan.notTopLevelPlan", Lists.newArrayList((Object[])new String[]{plan.getName()})));
        }
    }

    protected void validateName() {
        this.checkFieldXssSafety("repositoryName", this.repositoryName);
        if (StringUtils.isBlank((CharSequence)this.repositoryName)) {
            this.addFieldError("repositoryName", this.getText("repository.name.not.set"));
        } else if (this.vcsRepositoryConfigurationService.validateRepositoryName(this.getImmutablePlan(), this.repositoryName, (BambooIdProvider)this.repositoryDefinition)) {
            if (this.isGlobalRepository()) {
                this.addActionError(this.getText("repository.name.already.exists"));
            } else {
                this.addFieldError("repositoryName", this.getText("repository.name.already.exists"));
            }
        }
    }

    protected void validateGlobalRepositoryUse() {
        long repositoryId;
        if (this.isGlobalRepository() && (repositoryId = Long.parseLong(this.getBuildConfiguration().getString(this.SELECTED_REPOSITORY))) != this.getRepositoryId()) {
            this.vcsConfigurationHelper.validateRepositoryExistenceAndPermissions(repositoryId, (ValidationAware)this);
        }
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public PartialVcsRepositoryData getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public String getSelectedWebRepositoryViewer() {
        return this.selectedWebRepositoryViewer;
    }

    public void setSelectedWebRepositoryViewer(String selectedWebRepositoryViewer) {
        this.selectedWebRepositoryViewer = selectedWebRepositoryViewer;
    }

    public int getRepositoryNameMaxLength() {
        return 255;
    }

    protected void validateRepositoryConfiguration(boolean overrideBranch) {
        this.validateName();
        if (!this.isGlobalRepository()) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForPlan(this.getImmutablePlan()), () -> this.lambda$validateRepositoryConfiguration$0((ErrorCollection)errorCollection));
            this.addErrorCollection((ErrorCollection)errorCollection);
        } else {
            this.validateGlobalRepositoryUse();
            if (overrideBranch) {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForPlan(this.getImmutablePlan()), () -> this.lambda$validateRepositoryConfiguration$1((ErrorCollection)errorCollection));
                this.addErrorCollection((ErrorCollection)errorCollection);
            }
        }
    }

    public boolean isDerivedFromLinkedRepository() {
        return this.repositoryDefinition.isRootVcsLinked();
    }

    public boolean isBranchOverridable() {
        return this.vcsRepositoryModuleDescriptor != null && this.vcsRepositoryModuleDescriptor.supportsBranchOverrides();
    }

    protected void triggerAnalyticsEvent() {
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    private boolean isGlobalRepository() {
        return NumberUtils.isCreatable((String)this.getBuildConfiguration().getString(this.SELECTED_REPOSITORY));
    }

    private /* synthetic */ void lambda$validateRepositoryConfiguration$1(ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, errorCollection, EnumSet.of(VcsConfigurationHelper.Overrides.BRANCH));
    }

    private /* synthetic */ void lambda$validateRepositoryConfiguration$0(ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, errorCollection, VcsConfigurationHelper.OVERRIDE_ALL);
    }
}

