/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;

public class ConfigureChainRepositories
extends ConfigureRepository
implements PlanEditSecurityAware {
    private List<VcsRepositoryModuleDescriptor> vcsRepositoryModuleDescriptors;
    private List<VcsUIConfigBean.VcsTypeSelector> vcsTypeSelectors;
    private List<PlanRepositoryLink> repositoryLinks;
    private List<? extends VcsRepositoryData> repositoryDefinitions;

    private List<VcsUIConfigBean.VcsTypeSelector> createVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        ArrayList<VcsUIConfigBean.VcsTypeSelector> selectors = new ArrayList<VcsUIConfigBean.VcsTypeSelector>();
        if (this.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY)) {
            this.vcsRepositoryModuleDescriptors.stream().map(moduleDescriptor -> new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)moduleDescriptor, VcsUIConfigBean.VcsHtmlFragments.emptyFragments())).forEach(selectors::add);
        }
        Set alreadyUsed = this.getRepositoryLinks().stream().flatMap(r -> {
            long id = r.getRepositoryDataEntity().getId();
            if (r.getRepositoryDataEntity().getParent() != null) {
                return Stream.of(id, r.getRepositoryDataEntity().getParent().getId());
            }
            return Stream.of(Long.valueOf(id));
        }).collect(Collectors.toSet());
        Stream<VcsRepositoryData> notUsedLinkedRepositories = this.cachedRepositoryDefinitionAccessor.getLinkedRepositories().stream().filter(input -> input != null && !alreadyUsed.contains(input.getId()));
        String globalGroup = this.getText("repository.type.shared");
        notUsedLinkedRepositories.map(linkedRepositoryData -> {
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(linkedRepositoryData.getPluginKey());
            if (vcsRepositoryModuleDescriptor != null) {
                return new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryData)linkedRepositoryData, vcsRepositoryModuleDescriptor, globalGroup, VcsUIConfigBean.VcsHtmlFragments.emptyFragments(), true);
            }
            return null;
        }).filter(Objects::nonNull).forEach(selectors::add);
        return selectors;
    }

    private void initRepositoryTypeSelectors() {
        this.initVcsRepositoryModuleDescriptors();
        if (this.vcsTypeSelectors == null) {
            this.vcsTypeSelectors = this.createVcsTypeSelectors(TaskRenderMode.SUCCESS);
        }
    }

    private void initVcsRepositoryModuleDescriptors() {
        if (this.vcsRepositoryModuleDescriptors == null) {
            this.vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableRepositoryDescriptors();
        }
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getVcsTypeSelectors() {
        this.initRepositoryTypeSelectors();
        return this.vcsTypeSelectors;
    }

    public List<? extends VcsRepositoryData> getRepositoryDefinitions() {
        if (this.repositoryDefinitions == null) {
            this.repositoryDefinitions = this.getRepositoryLinks().stream().map(prl -> new PlanRepositoryDefinitionImpl(prl, this.repositoryDefinitionManager.entityToUnmergedData(prl.getRepositoryDataEntity()))).collect(Collectors.toList());
        }
        return this.repositoryDefinitions;
    }

    private List<PlanRepositoryLink> getRepositoryLinks() {
        if (this.repositoryLinks == null) {
            this.repositoryLinks = this.repositoryDefinitionManager.getPlanRepositoryLinks(this.getImmutablePlan());
        }
        return this.repositoryLinks;
    }
}

