/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.configuration.external.PlanConfigExportService;
import com.atlassian.bamboo.configuration.external.PlanPermissionService;
import com.atlassian.bamboo.configuration.external.yaml.export.YamlEmitter;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.codegen.BambooSpecsGenerator;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ViewPlanSpecs
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(ViewPlanSpecs.class);
    private PlanConfigExportService planConfigExportService;
    private PlanPermissionService planPermissionService;
    private YamlEmitter yamlEmitter;
    private String exportItem;
    private String objectName;
    private boolean yaml;

    public String java() throws Exception {
        this.objectName = this.getMasterPlan().getName();
        try {
            this.exportItem = this.javaCode();
        }
        catch (CodeGenerationException e) {
            log.error(null, (Throwable)e);
            this.addActionError("Export to Bamboo Specs failed: " + e.getMessage());
            return "error";
        }
        return super.input();
    }

    public String yaml() throws Exception {
        this.yaml = true;
        this.objectName = this.getMasterPlan().getName();
        try {
            this.exportItem = this.yamlCode();
        }
        catch (CodeGenerationException e) {
            log.error(null, (Throwable)e);
            this.addActionError("Export to Bamboo YAML Specs failed: " + e.getMessage());
            return "error";
        }
        return super.input();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getExportItem() {
        return this.exportItem;
    }

    private ImmutableTopLevelPlan getMasterPlan() {
        if (this.getImmutablePlan().hasMaster()) {
            return (ImmutableTopLevelPlan)this.getImmutablePlan().getMaster();
        }
        return (ImmutableTopLevelPlan)this.getImmutablePlan();
    }

    private String javaCode() throws CodeGenerationException {
        ImmutableTopLevelPlan immutableTopLevelPlan = (ImmutableTopLevelPlan)this.cachedPlanManager.getPlanByKey(this.getImmutablePlan().getPlanKey(), ImmutableTopLevelPlan.class);
        Preconditions.checkNotNull((Object)immutableTopLevelPlan);
        Plan plan = this.planConfigExportService.exportPlanToSpecs(immutableTopLevelPlan);
        PlanProperties planProperties = (PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan);
        PlanIdentifierProperties planIdentifierProperties = (PlanIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan.getIdentifier());
        BambooSpecsGenerator specGenerator = new BambooSpecsGenerator();
        specGenerator.addEntity("plan", (EntityProperties)planProperties);
        try {
            PlanPermissionsProperties planPermissionProperties = this.planPermissionService.exportPlanPermission(planIdentifierProperties);
            specGenerator.addEntity("planPermission", (EntityProperties)planPermissionProperties);
        }
        catch (UnauthorisedException e) {
            specGenerator.addEntity("planPermissionUnauthorisedComment1", (EntityProperties)new BambooSpecsGenerator.Comment(String.format("Note: You are not authorized to view plan %s permissions. ", immutableTopLevelPlan.getKey()), true, false));
            specGenerator.addEntity("planPermissionUnauthorisedComment2", (EntityProperties)new BambooSpecsGenerator.Comment(String.format("Bamboo Java Specs for %s plan permissions are not generated. ", immutableTopLevelPlan.getKey()), false, true));
        }
        return specGenerator.emitCode(this.getBaseUrl());
    }

    private String yamlCode() throws CodeGenerationException {
        ImmutableTopLevelPlan immutableTopLevelPlan = (ImmutableTopLevelPlan)this.cachedPlanManager.getPlanByKey(this.getImmutablePlan().getPlanKey(), ImmutableTopLevelPlan.class);
        Preconditions.checkNotNull((Object)immutableTopLevelPlan);
        Plan plan = this.planConfigExportService.exportPlanToSpecs(immutableTopLevelPlan);
        PlanProperties planProperties = (PlanProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan);
        PlanIdentifierProperties planIdentifierProperties = (PlanIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)plan.getIdentifier());
        ArrayList<Object> entitiesToEmit = new ArrayList<Object>();
        entitiesToEmit.add(planProperties);
        try {
            entitiesToEmit.add(this.planPermissionService.exportPlanPermission(planIdentifierProperties));
        }
        catch (UnauthorisedException e) {
            entitiesToEmit.add(new BambooSpecsGenerator.Comment(String.format("Note: You are not authorized to view plan %s permissions. ", immutableTopLevelPlan.getKey()), true, false));
            entitiesToEmit.add(new BambooSpecsGenerator.Comment(String.format("Bamboo YAML Specs for %s plan permissions are not generated. ", immutableTopLevelPlan.getKey()), false, true));
        }
        return this.yamlEmitter.emitYamlDocuments(entitiesToEmit);
    }

    public void setPlanConfigExportService(PlanConfigExportService planConfigExportService) {
        this.planConfigExportService = planConfigExportService;
    }

    public void setPlanPermissionService(PlanPermissionService planPermissionService) {
        this.planPermissionService = planPermissionService;
    }

    public void setYamlEmitter(YamlEmitter yamlEmitter) {
        this.yamlEmitter = yamlEmitter;
    }

    public boolean isYaml() {
        return this.yaml;
    }
}

