/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.util.AgentComparator;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DescribeAgentAvailability
extends BuildActionSupport {
    private static final Logger log = Logger.getLogger(DescribeAgentAvailability.class);
    private final AgentComparator AGENT_COMPARATOR = new AgentComparator();
    private ExecutableAgentsHelper executableAgentsHelper;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @NotNull
    protected final LazyReference<ExecutableAgentsMatrix> executableAgents = new LazyReference<ExecutableAgentsMatrix>(){

        @NotNull
        protected ExecutableAgentsMatrix create() throws Exception {
            ImmutableBuildable build = DescribeAgentAvailability.this.getImmutableBuild();
            RequirementSet requirementSet = build.getEffectiveRequirementSet();
            ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)requirementSet, (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)build)).withDisabledIncluded().withOfflineIncluded();
            return DescribeAgentAvailability.this.executableAgentsHelper.getExecutableAgentsMatrix(executorQuery);
        }
    };

    @Override
    public String doDefault() throws Exception {
        if (this.getImmutableBuild() == null) {
            return this.planNotFound();
        }
        return super.doDefault();
    }

    public List<BuildAgent> sortMatchingAgents(Collection<BuildAgent> matchingAgents) {
        return Ordering.from((Comparator)this.AGENT_COMPARATOR).sortedCopy(matchingAgents);
    }

    @NotNull
    public ExecutableAgentsMatrix getExecutableAgentMatrix() {
        return (ExecutableAgentsMatrix)this.executableAgents.get();
    }

    public boolean isElasticBambooEnabled() {
        return this.elasticFunctionalityFacade.isElasticSupportEnabled();
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public void setExecutableAgentsHelper(ExecutableAgentsHelper executableAgentsHelper) {
        this.executableAgentsHelper = executableAgentsHelper;
    }
}

