/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.requirement.RequirementService;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.struts.TextProvider;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureBuildRequirement
extends BuildConfigurationSupport
implements PlanEditSecurityAware {
    private CapabilityRequirementSetDecorator decorator;
    private String requirementId;
    private String buildKey;
    private transient CapabilityHelper capabilityHelper;
    private transient ElasticFunctionalityFacade elasticFunctionalityFacade;
    private transient TaskManager taskManager;
    @Autowired
    private RequirementService requirementService;

    @Override
    public String doDefault() {
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(this.buildKey)));
            return "error";
        }
        return "input";
    }

    public CapabilityRequirementSetDecorator getRequirementSetDecorator() {
        ImmutablePlan plan = this.getImmutablePlan();
        ImmutableBuildable buildable = (ImmutableBuildable)Narrow.to((Object)plan, ImmutableBuildable.class);
        if (buildable == null) {
            throw new IncorrectPlanTypeException("Can not perform Requirement Actions against a plan that isn't buildable, planKey: " + plan.getKey());
        }
        if (this.decorator == null) {
            this.decorator = new CapabilityRequirementSetDecorator(buildable, buildable.getRequirementSet().getRequirements(), (TextProvider)this, this.capabilityHelper, this.taskManager);
        }
        return this.decorator;
    }

    public boolean isElasticBambooEnabled() {
        return this.elasticFunctionalityFacade.isElasticSupportEnabled();
    }

    public void setCapabilityHelper(CapabilityHelper capabilityHelper) {
        this.capabilityHelper = capabilityHelper;
    }

    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    @RssConfigurationAware
    public String removeRequirement() {
        PlanKey jobKey = PlanKeys.getPlanKey((String)this.buildKey);
        try {
            this.requirementService.removeRequirement(jobKey, Long.parseLong(this.requirementId));
            this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        }
        catch (WebValidationException e) {
            return "error";
        }
        return "success";
    }

    public void setRequirementId(String requirementId) {
        this.requirementId = requirementId;
    }

    @Override
    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }
}

