/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.user.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConfigureBuildNotification
extends BuildConfigurationSupport
implements PlanEditSecurityAware {
    private String notificationRecipientType;
    private String conditionKey;
    private long notificationId;
    private long lastModified;
    private NotificationManager notificationManager;
    private InstantMessagingServerManager instantMessagingServerManager;
    private final Map<String, NotificationType> notificationTypes = new TreeMap<String, NotificationType>();
    private final Map<String, NotificationRecipient> notificationRecipients = new TreeMap<String, NotificationRecipient>();
    private String edit;
    private String previousTypeData;

    @Override
    public String doDefault() throws Exception {
        NotificationType notificationType;
        ImmutablePlan build = this.getImmutablePlan();
        if (build == null) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        if (StringUtils.isNotBlank((CharSequence)this.previousTypeData) && (notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey)) != null) {
            notificationType.setConfigurationData(this.previousTypeData);
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        return "input";
    }

    @RssConfigurationAware
    public String doAddNotification() throws Exception {
        this.validateNotification();
        if (this.hasAnyErrors()) {
            return "input";
        }
        return this.createNotification();
    }

    public String createNotification() {
        Chain plan = (Chain)Narrow.to((Object)this.getMutablePlan(), Chain.class);
        NotificationSet notificationSet = plan.getNotificationSet();
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureBuildNotification.getActionParameters());
            notificationSet.addNotification(newRule);
            this.planManager.savePlan((Plan)plan);
            this.lastModified = newRule.getId();
            this.previousTypeData = newRule.getConditionData();
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    private static Map<String, String[]> getActionParameters() {
        return ActionParamsUtils.getStringArrayMap();
    }

    public String doDelete() {
        Chain plan = (Chain)Narrow.to((Object)this.getMutablePlan(), Chain.class);
        plan.getNotificationSet().removeNotificationRule(this.notificationId);
        this.planManager.savePlan((Plan)plan);
        return "success";
    }

    public String doEdit() {
        ImmutableChain plan = (ImmutableChain)Narrow.to((Object)this.getImmutablePlan(), ImmutableChain.class);
        NotificationSet notificationSet = plan.getNotificationSet();
        NotificationRule notificationRule = notificationSet.getNotificationRuleById(this.notificationId);
        if (notificationRule == null) {
            this.addActionError("Could not find notification rule with id: " + this.notificationId);
            return "error";
        }
        this.notificationRecipientType = StringUtils.defaultString((String)notificationRule.getRecipientType());
        this.conditionKey = StringUtils.defaultString((String)notificationRule.getConditionKey());
        this.updateObjectsForEdit(notificationRule);
        this.lastModified = this.notificationId;
        return "input";
    }

    public String doUpdate() {
        this.validateNotification();
        if (this.hasAnyErrors()) {
            return "input";
        }
        Chain plan = (Chain)Narrow.to((Object)this.getMutablePlan(), Chain.class);
        NotificationSet notificationSet = plan.getNotificationSet();
        try {
            NotificationRule newRule = this.notificationManager.createNotificationRuleFromAction(this.conditionKey, this.notificationRecipientType, ConfigureBuildNotification.getActionParameters());
            this.notificationManager.replaceNotificationRule(notificationSet, this.notificationId, newRule);
            this.lastModified = newRule.getId();
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
        return "success";
    }

    public void validateNotification() {
        NotificationType notificationType = this.notificationManager.getNotificationTypeFromKey(this.conditionKey);
        if (notificationType != null) {
            this.addErrorCollection(notificationType.validate(ConfigureBuildNotification.getActionParameters()));
            if (this.hasAnyErrors()) {
                return;
            }
        } else {
            this.addActionError("Failed to save notification, could not find associated plugin module for. " + this.conditionKey);
            return;
        }
        this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        notificationType.populate(ConfigureBuildNotification.getActionParameters());
        String configData = notificationType.getConfigurationData();
        NotificationRecipient notificationRecipient = this.notificationManager.getNotificationRecipientFromKey(this.notificationRecipientType);
        this.addErrorCollection(notificationRecipient.validate(ConfigureBuildNotification.getActionParameters()));
        this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
        ImmutableChain plan = (ImmutableChain)Narrow.to((Object)this.getImmutablePlan(), ImmutableChain.class);
        NotificationSet notificationSet = plan.getNotificationSet();
        NotificationRule newRule = this.notificationManager.createNotificationRule(this.conditionKey, configData, notificationRecipient.getRecipientConfig(), this.notificationRecipientType);
        for (NotificationRule oldRule : notificationSet.getNotificationRules()) {
            if (!oldRule.equals(newRule) || this.notificationId == oldRule.getId()) continue;
            this.addActionError("Notification already exists for this build");
        }
    }

    private void updateObjectsForEdit(NotificationRule rule) {
        NotificationRecipient notificationRecipient;
        NotificationType notificationType = this.notificationManager.getNotificationType(rule);
        if (notificationType != null) {
            this.getNotificationTypes().put(notificationType.getKey(), notificationType);
        }
        if ((notificationRecipient = this.notificationManager.getNotificationRecipient(rule)) != null) {
            this.getAvailableRecipientTypes().put(notificationRecipient.getKey(), notificationRecipient);
        }
    }

    public Map<String, NotificationRecipient> getAvailableRecipientTypes() {
        if (this.notificationRecipients.isEmpty()) {
            this.notificationManager.getAllNotificationRecipients().stream().filter(recipient -> recipient.getScopes().isEmpty() || recipient.getScopes().contains(NotificationRecipient.Scope.CHAIN)).forEach(recipient -> this.notificationRecipients.put(recipient.getKey(), (NotificationRecipient)recipient));
        }
        return this.notificationRecipients;
    }

    private Map<String, NotificationType> getNotificationTypes() {
        if (this.notificationTypes.isEmpty()) {
            List notificationTypeObjects = this.notificationManager.getPlanNotificationTypes();
            for (NotificationType type : notificationTypeObjects) {
                this.notificationTypes.put(type.getKey(), type);
            }
        }
        return this.notificationTypes;
    }

    public List<NotificationRecipient> getAllNotificationRecipientTypes() {
        return this.getAvailableRecipientTypes().values().stream().sorted().collect(Collectors.toList());
    }

    public List<NotificationType> getAllNotificationEventTypes() {
        return this.getNotificationTypes().values().stream().sorted().collect(Collectors.toList());
    }

    public List<Group> getAvailableGroups() {
        return this.uiConfigBean.getAvailableGroups();
    }

    public List<String> getAvailableUsers() {
        return this.uiConfigBean.getAvailableUserNames();
    }

    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationRowId) {
        this.notificationId = notificationRowId;
    }

    public String getEdit() {
        return this.edit;
    }

    public void setEdit(String edit) {
        this.edit = edit;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getNotificationRecipientType() {
        return this.notificationRecipientType;
    }

    public void setNotificationRecipientType(String notificationRecipientType) {
        this.notificationRecipientType = notificationRecipientType;
    }

    public String getConditionKey() {
        return this.conditionKey;
    }

    public void setConditionKey(String conditionKey) {
        this.conditionKey = conditionKey;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean isMailServerConfigured() {
        return this.getMailServerManager().isDefaultSMTPMailServerDefined();
    }

    public void setInstantMessagingServerManager(InstantMessagingServerManager instantMessagingServerManager) {
        this.instantMessagingServerManager = instantMessagingServerManager;
    }

    public boolean isJabberServerConfigured() {
        Collection instantMessagingServers = this.instantMessagingServerManager.getAllInstantMessagingServers();
        return instantMessagingServers != null && !instantMessagingServers.isEmpty();
    }

    protected MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    public String getPreviousTypeData() {
        return this.previousTypeData;
    }

    public void setPreviousTypeData(String previousTypeData) {
        this.previousTypeData = previousTypeData;
    }
}

