/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildCompleteActionModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildProcessorModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildProcessorServerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.CustomPostBuildCompletedActionModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.CustomPreBuildActionModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.CustomPreBuildQueuedActionModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.MiscellaneousBuildConfigurationModuleDescriptor;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildConfigurationAwarePlugin;
import com.atlassian.bamboo.v2.build.ConfigurablePlugin;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.configuration.MiscellaneousBuildConfigurationPlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.BuildConfigurationSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConfigureBuildMiscellaneousOptions
extends BuildConfigurationSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureBuildMiscellaneousOptions.class);
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;
    private static final Class[] DESCRIPTORS_ON_JOB_PAGE = new Class[]{CustomPreBuildQueuedActionModuleDescriptor.class, CustomPreBuildActionModuleDescriptor.class, CustomBuildProcessorServerModuleDescriptor.class, CustomBuildProcessorModuleDescriptor.class, CustomBuildCompleteActionModuleDescriptor.class, CustomPostBuildCompletedActionModuleDescriptor.class};

    public String input() throws Exception {
        ImmutablePlan build = this.getImmutablePlan();
        if (build == null) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        return super.input();
    }

    public String execute() {
        BuildConfiguration config = this.getBuildConfiguration();
        for (MiscellaneousBuildConfigurationPlugin plugin : this.planConfigurationUIPluginHelper.getBuildConfigurationPlugins(this.getMutablePlan(), MiscellaneousBuildConfigurationPlugin.class)) {
            if (!plugin.isConfigurationMissing(config)) continue;
            plugin.addDefaultValues(config);
        }
        for (ConfigurablePlugin pluginModule : this.getConfigurablePluginsForMiscTab()) {
            pluginModule.addDefaultValues(config);
        }
        return "input";
    }

    public void validate() {
        ImmutablePlan build = this.getImmutablePlan();
        if (build == null) {
            this.addActionError(this.getText("build.error.plan.not.exists", Collections.singletonList(this.getPlanKey())));
            return;
        }
        BuildConfiguration config = this.getBuildConfiguration();
        for (BuildConfigurationAwarePlugin plugin : this.getPluginModulesForPage()) {
            plugin.prepareConfigObject(config);
            ErrorCollection errorCollection = plugin.validate(config);
            if (errorCollection == null || !errorCollection.hasAnyErrors()) continue;
            this.addErrorCollection(errorCollection);
        }
    }

    @RssConfigurationAware
    public String create() throws Exception {
        ImmutableBuildable buildable = (ImmutableBuildable)Narrow.to((Object)this.getImmutablePlan(), ImmutableBuildable.class);
        if (buildable != null) {
            BuildConfiguration buildConfiguration = this.getBuildConfiguration();
            RequirementSet requirementSet = buildable.getRequirementSet();
            for (ConfigurablePlugin pluginModule : this.getConfigurablePluginsForMiscTab()) {
                pluginModule.customizeBuildRequirements(buildable.getPlanKey(), buildConfiguration, requirementSet);
            }
        }
        return this.savePlan();
    }

    @NotNull
    public List<String> getMiscellaneousBuildConfigurationEditHtmlList() {
        ArrayList<String> htmlList = new ArrayList<String>(this.planConfigurationUIPluginHelper.getEditHtmlList(this.getBuildConfiguration(), this.getMutablePlan(), MiscellaneousBuildConfigurationPlugin.class, new Class[]{MiscellaneousBuildConfigurationModuleDescriptor.class}));
        if (this.getImmutablePlan() instanceof ImmutableBuildable) {
            for (Class descriptor : DESCRIPTORS_ON_JOB_PAGE) {
                htmlList.addAll(this.planConfigurationUIPluginHelper.getEditHtmlList(this.getBuildConfiguration(), this.getMutablePlan(), ConfigurablePlugin.class, new Class[]{descriptor}));
            }
        }
        return htmlList;
    }

    private Iterable<ConfigurablePlugin> getConfigurablePluginsForMiscTab() {
        if (this.getImmutablePlan() instanceof ImmutableBuildable) {
            return this.planConfigurationUIPluginHelper.getBuildConfigurationPlugins(this.getMutablePlan(), ConfigurablePlugin.class, DESCRIPTORS_ON_JOB_PAGE);
        }
        return Collections.emptyList();
    }

    private Iterable<BuildConfigurationAwarePlugin> getPluginModulesForPage() {
        return Iterables.concat((Iterable)this.planConfigurationUIPluginHelper.getBuildConfigurationPlugins(this.getMutablePlan(), MiscellaneousBuildConfigurationPlugin.class), this.getConfigurablePluginsForMiscTab());
    }

    public void setPlanConfigurationUIPluginHelper(PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper) {
        this.planConfigurationUIPluginHelper = planConfigurationUIPluginHelper;
    }
}

