/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DockerConfigurationProviders;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.web.conditions.DockerPipelinesEnabledCondition;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@ConditionallyAvailable(condition={DockerPipelinesEnabledCondition.class})
public class ConfigureBuildDocker
extends BuildActionSupport
implements PlanEditSecurityAware {
    private boolean saved;
    private String isolationType;
    private List<DockerConfigurationProviders.Config> dockerHandlers;
    private static final boolean IS_DOCKER_CREATE = false;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private DockerConfigurationProviders dockerConfigurationProviders;

    public String input() {
        ImmutableBuildable build = this.getImmutableBuild();
        if (!PlanClassHelper.isJob((ImmutablePlan)build)) {
            this.addActionError(this.getText("build.error.build.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        this.dockerHandlers = this.dockerConfigurationProviders.getConfigs(build.getBuildDefinition(), false);
        this.isolationType = this.dockerHandlers.stream().filter(t -> t.isSelected()).map(t -> t.getIsolationType()).findFirst().orElse(BuildEnvironmentType.AGENT.name());
        return "input";
    }

    @RssConfigurationAware
    public String execute() {
        Buildable mutableBuild = this.getMutableBuild();
        if (!PlanClassHelper.isJob((ImmutablePlan)mutableBuild)) {
            this.addActionError(this.getText("build.error.build.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        String buildEnvironmentType = this.getValidIsolationType();
        if (buildEnvironmentType == null) {
            this.addFieldError("isolationType", this.getText("build.isolation.error.invalid"));
            return "error";
        }
        Job job = (Job)mutableBuild;
        this.addErrorCollection(this.dockerConfigurationProviders.validateAndSaveSelectedConfig(job, false, buildEnvironmentType, this.getWebFragmentsContextMap()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    private String getValidIsolationType() {
        return this.dockerConfigurationProviders.isAllowedIsolationTypeValue(this.isolationType) ? this.isolationType : null;
    }

    public Map<String, String> getIsolationOptions() {
        return this.dockerConfigurationProviders.getIsolationTypeLabels(this.getTextProvider());
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public String getIsolationType() {
        return this.isolationType;
    }

    public void setIsolationType(String isolationType) {
        this.isolationType = isolationType;
    }

    public List<DockerConfigurationProviders.Config> getDockerHandlers() {
        if (this.dockerHandlers == null) {
            this.dockerHandlers = this.dockerConfigurationProviders.getConfigs(this.getWebFragmentsContextMap(), false);
        }
        return this.dockerHandlers;
    }
}

