/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.build.creation.RepositoryConfigHelper;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.JobPropagatingFacade;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.xwork2.Preparable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureBuildDetails
extends BuildActionSupport
implements PlanEditSecurityAware,
Preparable {
    private static final String BUILD_NAME = "buildName";
    private static final String BUILD_DESCRIPTION = "buildDescription";
    private ChainBranchManager chainBranchManager;
    private EventPublisher eventPublisher;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    private String buildName;
    private String buildDescription;
    private boolean saved;
    private boolean enabled;
    private WorkingDirectoryType workingDirSelector = WorkingDirectoryType.DEFAULT;
    private long repositoryDefiningWorkingDirectory = -1L;
    private PlanValidationService planValidationService;

    @Override
    public String doDefault() throws Exception {
        ImmutableBuildable build = this.getImmutableBuild();
        if (!PlanClassHelper.isJob((ImmutablePlan)build)) {
            this.addActionError(this.getText("build.error.build.not.exists", Collections.singletonList(this.getPlanKey())));
            return "error";
        }
        this.buildName = build.getBuildName();
        this.buildDescription = build.getDescription();
        this.enabled = !build.isSuspendedFromBuilding();
        return "input";
    }

    public void prepare() throws Exception {
        ImmutableBuildable build = this.getImmutableBuild();
        if (build != null) {
            this.repositoryDefiningWorkingDirectory = this.getImmutableBuild().getBuildDefinition().getRepositoryIdDefiningWorkingDir();
            if (this.repositoryDefiningWorkingDirectory != -1L) {
                this.workingDirSelector = WorkingDirectoryType.REPOSITORY;
            }
        }
    }

    public void validate() {
        ImmutableBuildable build = this.getImmutableBuild();
        this.planValidationService.validateName((ValidationAware)this, BUILD_NAME, "plan", this.buildName);
        this.planValidationService.validateDescription((ValidationAware)this, BUILD_DESCRIPTION, this.buildDescription);
        if (PlanClassHelper.isJob((ImmutablePlan)build)) {
            ImmutableJob job = (ImmutableJob)build;
            for (ImmutableJob existingJob : job.getParent().getAllJobs()) {
                if (existingJob == job || !existingJob.getBuildName().equals(this.buildName)) continue;
                this.addFieldError(BUILD_NAME, this.getText("job.name.exists"));
                break;
            }
            if (this.workingDirSelector == WorkingDirectoryType.DEFAULT) {
                this.repositoryDefiningWorkingDirectory = -1L;
            }
        } else {
            boolean isPlanNameConflicting = this.planManager.isChainNameConflicting(build.getProject().getKey(), build.getId(), this.buildName);
            if (isPlanNameConflicting) {
                this.addFieldError(BUILD_NAME, this.getText("plan.name.exists"));
            }
        }
    }

    @RssConfigurationAware
    public String create() throws Exception {
        boolean isTheSame;
        Job job = (Job)this.getMutableBuild();
        JobPropagatingFacade buildableFacade = new JobPropagatingFacade(this.chainBranchManager, job);
        boolean hasSuspensionStatusChanged = this.enabled == job.isSuspendedFromBuilding();
        boolean hasRepositoryDefiningWorkingDirChanged = job.getBuildDefinition().getRepositoryIdDefiningWorkingDir() != this.repositoryDefiningWorkingDirectory;
        boolean bl = isTheSame = job.getBuildName().equals(this.buildName) && StringUtils.equals((CharSequence)job.getDescription(), (CharSequence)this.buildDescription) && !hasSuspensionStatusChanged && !hasRepositoryDefiningWorkingDirChanged;
        if (!isTheSame) {
            buildableFacade.setBuildName(this.buildName);
            buildableFacade.setDescription(this.buildDescription);
            buildableFacade.savePlan(this.planManager);
            BuildDefinition buildDefinition = job.getBuildDefinition();
            if (hasRepositoryDefiningWorkingDirChanged) {
                buildDefinition.setRepositoryIdDefiningWorkingDir(this.repositoryDefiningWorkingDirectory);
            }
            this.buildDefinitionManager.savePlanAndDefinition((Plan)job, buildDefinition);
            if (hasSuspensionStatusChanged) {
                buildableFacade.setPlanSuspendedState(this.planManager, !this.enabled);
            }
            buildableFacade.publishBuildConfigurationUpdatedEvent(this.eventPublisher, (Object)this);
        }
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    public Map<Long, String> getRepositoriesForWorkingDirSelection() {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)this.getImmutableBuild(), ImmutableJob.class);
        if (job != null) {
            return RepositoryConfigHelper.getRepositoriesForWorkingDirSelection((ImmutableJob)job, (VcsRepositoryManager)this.vcsRepositoryManager);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getWorkingDirSelectorOptions() {
        return ImmutableMap.of((Object)WorkingDirectoryType.DEFAULT.name(), (Object)this.getText("job.workingDirectory.default"), (Object)WorkingDirectoryType.REPOSITORY.name(), (Object)this.getText("job.workingDirectory.repositoryDefined"));
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getBuildDescription() {
        return this.buildDescription;
    }

    public void setBuildDescription(String buildDescription) {
        this.buildDescription = buildDescription;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPlanValidationService(PlanValidationService planValidationService) {
        this.planValidationService = planValidationService;
    }

    public long getRepositoryDefiningWorkingDirectory() {
        return this.repositoryDefiningWorkingDirectory;
    }

    public void setRepositoryDefiningWorkingDirectory(long repositoryDefiningWorkingDirectory) {
        this.repositoryDefiningWorkingDirectory = repositoryDefiningWorkingDirectory;
    }

    public String getWorkingDirSelector() {
        return this.workingDirSelector.name();
    }

    public void setWorkingDirSelector(String workingDirSelector) {
        this.workingDirSelector = WorkingDirectoryType.valueOf(workingDirSelector);
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private static enum WorkingDirectoryType {
        DEFAULT,
        REPOSITORY;

    }
}

