/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.ArtifactDefinitionJsonDecorator;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConfigureBuildArtifact
extends PlanActionSupport
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureBuildArtifact.class);
    protected long artifactId;
    private String name;
    private String location;
    private String copyPattern;
    private boolean sharedArtifact;
    private boolean required;
    protected ArtifactDefinition artifactDefinition;
    private List<ArtifactDefinition> artifactDefinitions;
    private List<ArtifactSubscription> artifactSubscriptions;
    protected ArtifactDefinitionManager artifactDefinitionManager;
    protected ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private EventPublisher eventPublisher;

    @Override
    public String doDefault() throws Exception {
        this.populateActionProperties();
        return "input";
    }

    public String input() throws Exception {
        this.populateActionProperties();
        return "input";
    }

    @RssConfigurationAware
    public String create() throws Exception {
        this.artifactDefinition = new ArtifactDefinitionImpl();
        Job job = (Job)Narrow.to((Object)this.getMutablePlan(), Job.class);
        if (job == null) {
            this.addActionError("plan.type.invalid");
            return "error";
        }
        this.artifactDefinition.setProducerJob(job);
        this.updateArtifactDefinitionFromUserInput(this.artifactDefinition);
        this.validateArtifact(this.artifactDefinition);
        if (this.hasErrors()) {
            return "error";
        }
        this.artifactDefinitionManager.saveArtifactDefinition(this.artifactDefinition);
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    @RssConfigurationAware
    public String update() {
        this.artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(this.artifactId);
        if (this.artifactDefinition != null) {
            this.updateArtifactDefinitionFromUserInput(this.artifactDefinition);
            this.validateArtifact(this.artifactDefinition);
            if (this.hasAnyErrors()) {
                return "error";
            }
            if (this.shouldRemoveSubscriptions(this.artifactDefinition)) {
                this.artifactSubscriptionManager.removeArtifactSubscriptions(new ArrayList(this.artifactDefinition.getSubscriptions()));
            }
            this.artifactDefinitionManager.saveArtifactDefinition(this.artifactDefinition);
            this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
            return "success";
        }
        return "input";
    }

    @RssConfigurationAware
    public String delete() {
        this.artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(this.artifactId);
        if (this.artifactDefinition != null) {
            this.artifactDefinitionManager.removeArtifactDefinition(this.artifactDefinition);
        }
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        return "success";
    }

    @Override
    @NotNull
    protected JSONObject buildJsonObject() throws JSONException {
        JSONObject jsonObject = super.buildJsonObject();
        if (this.artifactDefinition != null) {
            jsonObject.put("artifactDefinition", (Object)new ArtifactDefinitionJsonDecorator(this.artifactDefinition).getJson());
        }
        return jsonObject;
    }

    @NotNull
    public List<DeploymentProject> getDeploymentProjectsUsingArtifact(@NotNull ArtifactDefinition artifactDefinition) {
        return this.deploymentProjectService.getDeploymentProjectsRelatedToArtifact(artifactDefinition);
    }

    public boolean isPlanUsedInDeployments() {
        PlanKey chainKey = PlanKeys.getChainKeyFromJobKey((PlanKey)this.getImmutablePlan().getPlanKey());
        return !this.deploymentProjectService.getDeploymentProjectsRelatedToPlan(chainKey).isEmpty();
    }

    private void populateActionProperties() {
        this.artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(this.artifactId);
        if (this.artifactDefinition != null) {
            this.name = this.artifactDefinition.getName();
            this.location = this.artifactDefinition.getLocation();
            this.copyPattern = this.artifactDefinition.getCopyPattern();
            this.sharedArtifact = this.artifactDefinition.isSharedArtifact();
            this.required = this.artifactDefinition.isRequired();
        }
    }

    private void updateArtifactDefinitionFromUserInput(ArtifactDefinition artifact) {
        artifact.setName(this.name);
        artifact.setLocation(this.location);
        artifact.setCopyPattern(this.copyPattern);
        artifact.setSharedArtifact(this.sharedArtifact);
        artifact.setRequired(this.required);
    }

    protected void validateArtifact(ArtifactDefinition artifact) {
        this.checkFieldXssSafety("name", artifact.getName());
        this.checkFieldXssSafety("location", artifact.getLocation());
        this.checkFieldXssSafety("copyPattern", artifact.getCopyPattern());
        if (StringUtils.isBlank((CharSequence)artifact.getName())) {
            this.addFieldError("name", this.getText("artifact.name.required"));
        } else if (!this.artifactDefinitionManager.isArtifactDefinitionNameUniqueInJob(artifact)) {
            this.addFieldError("name", this.getText("artifact.name.duplicate.in.job"));
        } else if (artifact.isSharedArtifact() && !this.artifactDefinitionManager.isArtifactDefinitionNameUniqueInChain(artifact)) {
            this.addFieldError("name", this.getText("artifact.name.duplicate.in.plan"));
        } else if (artifact.getName().contains("/")) {
            this.addFieldError("name", this.getText("error.string.unsafe", null, "/"));
        }
        if (StringUtils.isNotBlank((CharSequence)artifact.getLocation()) && StringUtils.contains((CharSequence)artifact.getLocation(), (CharSequence)"*")) {
            this.addFieldError("location", this.getText("artifact.location.error.asterisk"));
        }
        if (StringUtils.isBlank((CharSequence)artifact.getCopyPattern())) {
            this.addFieldError("copyPattern", this.getText("artifact.copyPattern.required"));
        }
    }

    private boolean shouldRemoveSubscriptions(@NotNull ArtifactDefinition artifact) {
        return !this.hasAnyErrors() && !artifact.isSharedArtifact() && artifact.hasSubscriptions();
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    public long getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(long artifactId) {
        this.artifactId = artifactId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCopyPattern() {
        return this.copyPattern;
    }

    public void setCopyPattern(String copyPattern) {
        this.copyPattern = copyPattern;
    }

    public boolean isSharedArtifact() {
        return this.sharedArtifact;
    }

    public void setSharedArtifact(boolean sharedArtifact) {
        this.sharedArtifact = sharedArtifact;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public ArtifactDefinition getArtifactDefinition() {
        if (this.artifactDefinition == null) {
            this.artifactDefinition = this.artifactDefinitionManager.findArtifactDefinition(this.artifactId);
        }
        return this.artifactDefinition;
    }

    public List<ArtifactDefinition> getArtifactDefinitions() {
        if (this.artifactDefinitions == null) {
            this.artifactDefinitions = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.artifactDefinitionManager.findArtifactDefinitionsByPlan(this.getImmutablePlan()));
        }
        return this.artifactDefinitions;
    }

    public List<ArtifactSubscription> getArtifactSubscriptions() {
        if (this.artifactSubscriptions == null) {
            this.artifactSubscriptions = this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)this.getImmutablePlan());
        }
        return this.artifactSubscriptions;
    }

    public boolean isArtifactSubscriptionPossible() {
        ImmutableJob job = (ImmutableJob)Narrow.to((Object)this.getImmutablePlan(), ImmutableJob.class);
        if (job != null) {
            return !job.getStage().equals(job.getParent().getStages().get(0));
        }
        return false;
    }

    public String getNiceSizeMessage(long size) {
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    public Multimap<ChainStage, Job> getJobsSubscribedToArtifact(@NotNull ArtifactDefinition artifactDefinition) {
        Set subscriberJobs = artifactDefinition.getSubscriptions().stream().map(ArtifactSubscriptionsFunctions::getConsumerJob).collect(Collectors.toSet());
        Job producerJob = (Job)Narrow.to((Object)artifactDefinition.getProducerJob(), Job.class);
        if (producerJob != null) {
            TreeMultimap result = TreeMultimap.create((Comparator)Ordering.explicit((List)producerJob.getParent().getStages()), (Comparator)Comparators.getNameProviderCaseInsensitiveOrdering());
            for (Job job : subscriberJobs) {
                result.put((Object)job.getStage(), (Object)job);
            }
            return ImmutableMultimap.copyOf((Multimap)result);
        }
        return ImmutableMultimap.of();
    }
}

