/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.config;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.ArtifactSubscriptionJsonDecorator;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigureArtifactSubscription
extends PlanActionSupport
implements PlanEditSecurityAware {
    private long subscriptionId;
    private long artifactDefinitionId;
    private String destination;
    private ArtifactSubscription artifactSubscription;
    private List<ArtifactSubscription> artifactSubscriptions;
    private List<ArtifactDefinition> availableSubscriptions;
    private ArtifactDefinitionManager artifactDefinitionManager;
    private ArtifactSubscriptionManager artifactSubscriptionManager;

    @Override
    public String doDefault() throws Exception {
        this.populateActionProperties();
        return "input";
    }

    public String input() throws Exception {
        this.populateActionProperties();
        return "input";
    }

    @RssConfigurationAware
    public String create() throws Exception {
        ArtifactSubscriptionImpl artifactSubscription = new ArtifactSubscriptionImpl();
        this.updateArtifactSubscription(artifactSubscription);
        this.validateSubscription();
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.artifactSubscriptionManager.saveArtifactSubscription((ArtifactSubscription)artifactSubscription);
        return "success";
    }

    @RssConfigurationAware
    public String update() {
        this.artifactSubscription = this.artifactSubscriptionManager.findSubscription(this.subscriptionId);
        if (this.artifactSubscription != null) {
            this.validateSubscription();
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.updateArtifactSubscription((ArtifactSubscriptionImpl)this.artifactSubscription);
            this.artifactSubscriptionManager.saveArtifactSubscription(this.artifactSubscription);
            return "success";
        }
        return "input";
    }

    @RssConfigurationAware
    public String delete() {
        this.artifactSubscription = this.artifactSubscriptionManager.findSubscription(this.subscriptionId);
        if (this.artifactSubscription != null) {
            this.artifactSubscriptionManager.removeArtifactSubscription(this.artifactSubscription);
        }
        return "success";
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        if (this.artifactSubscription != null) {
            jsonObject.put("artifactSubscription", (Object)new ArtifactSubscriptionJsonDecorator(this.artifactSubscription).getJson());
        }
        return jsonObject;
    }

    private void populateActionProperties() {
        this.artifactSubscription = this.artifactSubscriptionManager.findSubscription(this.subscriptionId);
        if (this.artifactSubscription != null) {
            this.artifactDefinitionId = this.artifactSubscription.getArtifactDefinition().getId();
            this.destination = this.artifactSubscription.getDestinationDirectory();
        }
    }

    private void updateArtifactSubscription(@NotNull ArtifactSubscriptionImpl artifactSubscription) {
        ArtifactDefinition definition = this.artifactDefinitionManager.findArtifactDefinition(this.artifactDefinitionId);
        artifactSubscription.setArtifactDefinition(definition);
        artifactSubscription.setDestinationDirectory(this.destination);
        artifactSubscription.setConsumerJob((Job)this.getMutablePlan());
    }

    private void validateSubscription() {
        this.checkFieldXssSafety("destination", this.destination);
        if (this.artifactDefinitionId == 0L) {
            this.addFieldError("artifactDefinitionId", this.getText("artifact.definition.required"));
        }
        this.destination = this.destination.trim();
        if (!this.isSubscriptionUnique()) {
            this.addActionError(this.getText("artifact.subscription.non.unique"));
        }
    }

    private boolean isSubscriptionUnique() {
        List subscriptions = this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)this.getImmutablePlan());
        for (ArtifactSubscription subscription : subscriptions) {
            boolean bothDestinationsEmpty;
            boolean bl = bothDestinationsEmpty = StringUtils.isEmpty((CharSequence)subscription.getDestinationDirectory()) && StringUtils.isEmpty((CharSequence)this.destination);
            if (subscription.getArtifactDefinition().getId() != this.artifactDefinitionId || !bothDestinationsEmpty && !this.destination.equals(subscription.getDestinationDirectory()) || subscription.getId() == this.subscriptionId) continue;
            return false;
        }
        return true;
    }

    public void setArtifactDefinitionManager(ArtifactDefinitionManager artifactDefinitionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(long subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public ArtifactSubscription getArtifactSubscription() {
        return this.artifactSubscription;
    }

    public void setArtifactSubscription(ArtifactSubscription artifactSubscription) {
        this.artifactSubscription = artifactSubscription;
    }

    public long getArtifactDefinitionId() {
        return this.artifactDefinitionId;
    }

    public void setArtifactDefinitionId(long artifactDefinitionId) {
        this.artifactDefinitionId = artifactDefinitionId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public List<ArtifactSubscription> getArtifactSubscriptions() {
        if (this.artifactSubscriptions == null) {
            this.artifactSubscriptions = this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)this.getImmutablePlan());
        }
        return this.artifactSubscriptions;
    }

    public List<ArtifactDefinition> getAvailableArtifacts() {
        if (this.availableSubscriptions == null) {
            this.availableSubscriptions = this.artifactSubscriptionManager.findSubscriptionsPossibleForPlan((ImmutableJob)this.getImmutablePlan());
        }
        return this.availableSubscriptions;
    }
}

