/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.JobPropagatingFacade;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;

public class SuspendJob
extends BuildActionSupport
implements PlanEditSecurityAware {
    private EventPublisher eventPublisher;
    private ChainBranchManager chainBranchManager;

    @RssConfigurationAware
    public String suspendJob() throws Exception {
        return this.suspendJob(true);
    }

    @RssConfigurationAware
    public String resumeJob() throws Exception {
        return this.suspendJob(false);
    }

    private String suspendJob(boolean suspendState) {
        ImmutablePlan plan = this.getImmutablePlan();
        if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
            Job job = (Job)this.getMutablePlan();
            JobPropagatingFacade buildableFacade = job.hasMaster() && !job.isDivergent() ? new JobPropagatingFacade(this.chainBranchManager, job.getMaster()) : new JobPropagatingFacade(this.chainBranchManager, job);
            buildableFacade.setPlanSuspendedState(this.planManager, suspendState);
            buildableFacade.publishBuildConfigurationUpdatedEvent(this.eventPublisher, (Object)this);
        }
        return "success";
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setChainBranchManager(ChainBranchManager chainBranchManager) {
        this.chainBranchManager = chainBranchManager;
    }
}

