/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ReorderBuild
extends BambooActionSupport
implements PlanAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ReorderBuild.class);
    private String resultKey;
    private String prevResultKey;
    private QueueItemViewForJsonDecorator.ItemType itemType = QueueItemViewForJsonDecorator.ItemType.BUILD;
    private BuildLoggerManager buildLoggerManager;
    private BuildQueueManager buildQueueManager;
    @Autowired
    private EnvironmentService environmentService;

    public String execute() throws Exception {
        PlanResultKey resultKey = this.itemType == QueueItemViewForJsonDecorator.ItemType.BUILD ? PlanKeys.getPlanResultKey((String)this.getResultKey()) : DeploymentResultKeyImpl.from((String)this.getResultKey());
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)resultKey);
        buildLogger.addBuildLogEntry("User " + this.getUser().getName() + " is moving build " + this.getResultKey());
        int index = this.prevResultKey != null ? Iterables.indexOf((Iterable)this.buildQueueManager.getQueuedExecutables(), (Predicate)new Predicate<BuildQueueManager.QueuedResultKey>(){

            public boolean apply(BuildQueueManager.QueuedResultKey input) {
                return input.getResultKey().toString().equals(ReorderBuild.this.prevResultKey);
            }
        }) + 1 : 0;
        boolean reordered = this.buildQueueManager.reorderInQueue((ResultKey)resultKey, index);
        if (!reordered) {
            this.addActionError("Queue out of order");
            return "error";
        }
        return super.execute();
    }

    @Override
    public Object getSecuredDomainObject() {
        switch (this.itemType) {
            case BUILD: {
                return this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanResultKey((String)this.resultKey).getPlanKey());
            }
            case DEPLOYMENT: {
                Key environmentKey = DeploymentResultKeyImpl.from((String)this.getResultKey()).getEntityKey();
                long environmentId = Long.parseLong(StringUtils.split((String)environmentKey.getKey(), (char)'-')[1]);
                return this.environmentService.getEnvironment(environmentId);
            }
        }
        throw new IllegalStateException("Neither build nor deployment.");
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }

    public void setItemType(String itemType) {
        this.itemType = QueueItemViewForJsonDecorator.ItemType.valueOf(itemType);
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public String getPrevResultKey() {
        return this.prevResultKey;
    }

    public void setPrevResultKey(String prevResultKey) {
        this.prevResultKey = prevResultKey;
    }
}

