/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.credentials.CredentialsUsageDetector;
import com.atlassian.bamboo.event.BuildsMovedEvent;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.plan.FilteringPlanManager;
import com.atlassian.bamboo.plan.MovePlanService;
import com.atlassian.bamboo.plan.MovePlansException;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.map.StringArrayMap;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkActionScope;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class MoveBuilds
extends GlobalAdminAction
implements BulkActionScope {
    private static final Logger log = Logger.getLogger(MoveBuilds.class);
    private List<Project> projects;
    private long[] planIds;
    private String projectName;
    private String projectKey;
    private String projectDescription;
    private String existingProjectKey;
    private Collection<TopLevelPlan> selectedPlans;
    private Collection<String> selectedPlanKeys;
    private Project selectedProject;
    private Map<String, String> planIdMappings = new StringArrayMap();
    private Map<String, String> planKeyMappings = new StringArrayMap();
    private Map<String, String> planNameMappings = new StringArrayMap();
    @Autowired
    private AgentManager agentManager;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private PlanValidationService planValidationService;
    @Autowired
    private MovePlanService movePlanService;
    @Autowired
    private ProjectConfigurationService projectConfigurationService;
    @Autowired
    private CredentialsUsageDetector credentialsUsageDetector;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    private FilteringPlanManager filteringPlanManager;

    public String selectPlans() {
        this.validateProject();
        if (this.hasAnyErrors()) {
            return "input";
        }
        Project project = this.getSelectedProject();
        Collection<TopLevelPlan> plans = this.getSelectedPlans();
        Iterator<TopLevelPlan> it = plans.iterator();
        while (it.hasNext()) {
            TopLevelPlan plan = it.next();
            if (plan.getProject().getId() != project.getId()) continue;
            this.planIds = ArrayUtils.removeElement((long[])this.planIds, (long)plan.getId());
            it.remove();
        }
        if (this.planIds == null || this.planIds.length == 0) {
            this.addActionError(this.getText("build.move.plans.error.invalid"));
            return "input";
        }
        ArrayList plansUsingProjectSharedCredentials = new ArrayList();
        HashMultimap branchesUsingProjectSharedCredentials = HashMultimap.create();
        plans.stream().map(pl -> (ImmutableChain)Narrow.to((Object)pl, ImmutableChain.class)).filter(ch -> ch.getPlanRepositoryDefinitions().stream().anyMatch(prd -> !prd.isLinked() && !prd.isMarkedForDeletion() && !this.credentialsUsageDetector.getProjectSharedCredentialsForRepository((VcsRepositoryData)prd).isEmpty())).map(ch -> ch.getBuildName()).limit(5L).forEach(ch -> plansUsingProjectSharedCredentials.add(ch));
        plans.stream().map(pl -> (ImmutableChain)Narrow.to((Object)pl, ImmutableChain.class)).filter(ch -> !this.credentialsUsageDetector.getProjectSharedCredentialsForPlanTasks(ch).isEmpty()).map(ch -> ch.getBuildName()).limit(5L).forEach(ch -> plansUsingProjectSharedCredentials.add(ch));
        plans.stream().flatMap(pl -> this.filteringPlanManager.getBranchesOfChain(pl.getPlanKey())).filter(br -> this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)br).stream().anyMatch(vcs -> !this.credentialsUsageDetector.getProjectSharedCredentialsForRepository((VcsRepositoryData)vcs).isEmpty())).limit(5L).forEach(arg_0 -> MoveBuilds.lambda$selectPlans$12((Multimap)branchesUsingProjectSharedCredentials, arg_0));
        plans.stream().flatMap(pl -> this.filteringPlanManager.getBranchesOfChain(pl.getPlanKey())).filter(br -> br.isDivergent()).filter(br -> !this.credentialsUsageDetector.getProjectSharedCredentialsForPlanTasks((ImmutableChain)br).isEmpty()).limit(5L).forEach(arg_0 -> MoveBuilds.lambda$selectPlans$16((Multimap)branchesUsingProjectSharedCredentials, arg_0));
        if (plansUsingProjectSharedCredentials.size() > 0 || branchesUsingProjectSharedCredentials.size() > 0) {
            for (String chain : plansUsingProjectSharedCredentials) {
                this.addActionError(this.getText("build.move.plans.error.shared.credentials", new String[]{chain}));
            }
            for (String key : branchesUsingProjectSharedCredentials.keySet()) {
                Collection branchesForPlan = branchesUsingProjectSharedCredentials.get((Object)key);
                String branches = String.join((CharSequence)", ", branchesForPlan);
                this.addActionError(this.getText("build.move.plans.error.branches.shared.credentials", Arrays.asList(key, branches, branchesForPlan.size())));
            }
            return "input";
        }
        int i = 0;
        for (TopLevelPlan plan : this.getSelectedPlans()) {
            this.planIdMappings.put(String.valueOf(i), String.valueOf(plan.getId()));
            this.planKeyMappings.put(String.valueOf(i), plan.getBuildKey());
            this.planNameMappings.put(String.valueOf(i), plan.getBuildName());
            ++i;
        }
        this.movePlanService.validatePlanKeysAndNamesForProject((ValidationAware)this, project, this.planKeyMappings, this.planNameMappings);
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.request.plan.move.rename"));
        return "success";
    }

    private void validateProject() {
        if (this.isNewProject(this.existingProjectKey)) {
            this.planValidationService.validateNewProjectDetails((ValidationAware)this, this.projectName, this.projectKey, this.projectDescription);
        } else {
            Project existingProject = this.projectManager.getProjectByKey(this.existingProjectKey);
            if (existingProject == null) {
                this.addFieldError("existingProjectKey", "Could not find project with given key: " + this.existingProjectKey);
            }
        }
    }

    public String execute() throws Exception {
        this.validateProject();
        if (this.hasAnyErrors()) {
            return "input";
        }
        this.movePlanService.validatePlanKeysAndNamesForProject((ValidationAware)this, this.getSelectedProject(), this.planKeyMappings, this.planNameMappings);
        if (this.hasAnyErrors()) {
            return "input";
        }
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.plans.move"));
        Collection<TopLevelPlan> plans = this.getSelectedPlans();
        if (this.getSelectedProject().getId() == -1L) {
            this.selectedProject = this.projectConfigurationService.createProject(this.getSelectedProject().getKey(), this.getSelectedProject().getName(), this.getSelectedProject().getDescription(), false);
        }
        try {
            Map planKeyChanges = this.movePlanService.movePlansToProject(plans, this.getSelectedProject(), this.planIdMappings, this.planKeyMappings, this.planNameMappings);
            this.selectedPlans = null;
            this.eventPublisher.publish((Object)new BuildsMovedEvent((Object)this, planKeyChanges));
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.plans.moved"));
        }
        catch (MovePlansException e) {
            this.addActionError((Exception)((Object)e));
            log.error((Object)("Unable to move plans: " + this.planKeyMappings), (Throwable)e);
            this.eventPublisher.publish((Object)new BuildsMovedEvent((Object)this, e.getSuccessfulPlanKeyChanges()));
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.plans.move.error"));
            return "error";
        }
        return "success";
    }

    @Override
    public String doDefault() throws Exception {
        this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.admin.request.plan.move.choose"));
        return "input";
    }

    @NotNull
    public Collection<TopLevelPlan> getSelectedPlans() {
        if (this.selectedPlans == null) {
            this.selectedPlans = new ArrayList<TopLevelPlan>();
            if (this.planIds != null) {
                for (long planId : this.planIds) {
                    this.selectedPlans.add((TopLevelPlan)this.planManager.getPlanById(planId, TopLevelPlan.class));
                }
            }
        }
        return this.selectedPlans;
    }

    public Collection<String> getSelectedPlanKeys() {
        if (this.selectedPlanKeys == null) {
            this.selectedPlanKeys = Collections2.transform(this.getSelectedPlans(), (Function)new Function<TopLevelPlan, String>(){

                public String apply(@Nullable TopLevelPlan input) {
                    return ((TopLevelPlan)Preconditions.checkNotNull((Object)input)).getKey();
                }
            });
        }
        return this.selectedPlanKeys;
    }

    public Project getSelectedProject() {
        if (this.selectedProject == null) {
            this.selectedProject = this.isNewProject(this.existingProjectKey) ? this.projectManager.createProject(this.projectKey, this.projectName, this.projectDescription) : this.projectManager.getProjectByKey(this.existingProjectKey);
        }
        return this.selectedProject;
    }

    public boolean isNewProject(String existingProjectKey) {
        return "newProject".equals(existingProjectKey) || StringUtils.isEmpty((CharSequence)existingProjectKey);
    }

    public void setPlanIds(long[] buildIds) {
        this.planIds = buildIds;
    }

    public Map<String, String> getPlanIdMappings() {
        return this.planIdMappings;
    }

    public void setPlanIdMappings(Map<String, String> planIdMappings) {
        this.planIdMappings = planIdMappings;
    }

    public Map<String, String> getPlanKeyMappings() {
        return this.planKeyMappings;
    }

    public void setPlanKeyMappings(Map<String, String> planKeyMappings) {
        this.planKeyMappings = planKeyMappings;
    }

    public Map<String, String> getPlanNameMappings() {
        return this.planNameMappings;
    }

    public void setPlanNameMappings(Map<String, String> planNameMappings) {
        this.planNameMappings = planNameMappings;
    }

    public boolean isBuildQueuesDisabled() {
        return this.agentManager.checkPipelinesAreDisabled();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName != null ? projectName.trim() : null;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey != null ? projectKey.toUpperCase().trim() : null;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public String getExistingProjectKey() {
        return this.existingProjectKey;
    }

    public void setExistingProjectKey(String existingProjectKey) {
        this.existingProjectKey = existingProjectKey;
    }

    @Override
    public boolean isApplicableForRepositories() {
        return false;
    }

    public boolean isApplicable(BulkActionScope bulkAction, Project project) {
        return project != null && this.cachedPlanManager.getAnyPlan(PlanPredicates.withEqualProjectKey((Project)project)).isPresent();
    }

    @Override
    public boolean isApplicable(ImmutablePlan plan) {
        return !PlanClassHelper.isJob((ImmutablePlan)plan);
    }

    public boolean isPlanSelected(String planKey) {
        return this.getSelectedPlanKeys().contains(planKey);
    }

    public List<Project> getSortedProjects() {
        if (this.projects == null) {
            this.projects = this.projectManager.getSortedProjects();
        }
        return this.projects;
    }

    public List<ImmutableTopLevelPlan> getSortedTopLevelPlans(Project project) {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().filter(PlanPredicates.withEqualProjectKey((Project)project)).sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$selectPlans$16(Multimap branchesUsingProjectSharedCredentials, ImmutableChainBranch br) {
        branchesUsingProjectSharedCredentials.put((Object)br.getMaster().getBuildName(), (Object)br.getBuildName());
    }

    private static /* synthetic */ void lambda$selectPlans$12(Multimap branchesUsingProjectSharedCredentials, ImmutableChainBranch br) {
        branchesUsingProjectSharedCredentials.put((Object)br.getMaster().getBuildName(), (Object)br.getBuildName());
    }
}

