/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.event.DeletionFinishedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkActionScope;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteBuilds
extends BambooActionSupport
implements GlobalAdminSecurityAware,
BulkActionScope {
    private static final Logger log = Logger.getLogger(DeleteBuilds.class);
    private List<Project> projects;
    private String[] selectedProjects;
    private String[] selectedBuilds;
    @Autowired
    private DeletionService deletionService;
    @Autowired
    private EventPublisher eventPublisher;
    private String successMessage;

    public void setSelectedBuilds(String[] selectedBuilds) {
        this.selectedBuilds = selectedBuilds;
    }

    public String[] getSelectedBuilds() {
        return this.selectedBuilds;
    }

    public String[] getSelectedProjects() {
        return this.selectedProjects;
    }

    public void setSelectedProjects(String[] selectedProjects) {
        this.selectedProjects = selectedProjects;
    }

    public void validate() {
        if (this.selectedBuilds == null && this.selectedProjects == null) {
            this.addActionError(this.getText("builds.delete.error.none"));
            return;
        }
        for (Project project : this.getProjectsToConfirm()) {
            List<? extends Plan> plans = this.getSortedPlans(project);
            for (Plan plan : plans) {
                if (ArrayUtils.contains((Object[])this.selectedBuilds, (Object)plan.getKey())) continue;
                this.addActionError(this.getText("builds.delete.error.projectHasBuilds"));
            }
        }
        if (this.selectedBuilds != null) {
            for (String selectedBuild : this.selectedBuilds) {
                Chain chain = (Chain)this.planManager.getPlanByKey(selectedBuild, Chain.class);
                if (chain != null) continue;
                this.addActionError(this.getText("builds.delete.error.NonExistantBuild", new String[]{selectedBuild}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        this.deletionService.suspendDeletions();
        try {
            HashSet deletedPlanKeys = new HashSet();
            if (this.selectedProjects != null) {
                try {
                    List<String> projectKeys = Arrays.asList(this.selectedProjects);
                    deletedPlanKeys.addAll(this.deletionService.deleteProjects(projectKeys));
                }
                catch (Exception e) {
                    log.error((Object)("Bamboo failed to delete projects " + Arrays.toString(this.selectedProjects)), (Throwable)e);
                    this.addActionError("Error deleting projects " + e.getMessage());
                    String string = "error";
                    this.deletionService.resumeDeletions();
                    return string;
                }
                this.selectedProjects = null;
            }
            if (this.selectedBuilds != null) {
                try {
                    Collection plansNotDeletedWithProjects = Arrays.stream(this.selectedBuilds).filter(input -> !deletedPlanKeys.contains(PlanKeys.getPlanKey((String)input))).collect(Collectors.toList());
                    deletedPlanKeys.addAll(this.deletionService.deletePlans((Iterable)plansNotDeletedWithProjects));
                }
                catch (Exception e) {
                    log.error((Object)("Bamboo failed to delete plans " + Arrays.toString(this.selectedBuilds)), (Throwable)e);
                    this.addActionError("Error deleting plans " + e.getMessage());
                    String string = "error";
                    this.deletionService.resumeDeletions();
                    return string;
                }
                this.selectedBuilds = null;
            }
            this.setSuccessMessage("Successfully marked " + deletedPlanKeys.size() + " jobs and plans for background deletion. Deletion will occur in the background in a few minutes.");
            this.eventPublisher.publish((Object)new DeletionFinishedEvent());
        }
        finally {
            this.deletionService.resumeDeletions();
        }
        return "success";
    }

    public String confirm() throws Exception {
        return "confirm";
    }

    @NotNull
    public List<Job> getJobsToConfirm(Plan plan) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
        if (chain != null) {
            jobs.addAll(chain.getAllJobs());
        }
        return jobs;
    }

    @NotNull
    public List<Chain> getBuildsToConfirm() {
        if (this.selectedBuilds == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.selectedBuilds).map(planKey -> (Chain)this.planManager.getPlanByKey(planKey, Chain.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public List<Project> getProjectsToConfirm() {
        if (this.selectedProjects == null) {
            return Collections.emptyList();
        }
        ArrayList<Project> projectsSelected = new ArrayList<Project>();
        for (String selectedProjectKey : this.selectedProjects) {
            Project project = this.projectManager.getProjectByKey(selectedProjectKey);
            if (project == null) continue;
            projectsSelected.add(project);
        }
        return projectsSelected;
    }

    @Override
    public boolean isApplicableForRepositories() {
        return false;
    }

    public boolean isApplicable(BulkActionScope bulkAction, Project project) {
        return true;
    }

    @Override
    public boolean isApplicable(ImmutablePlan plan) {
        return !PlanClassHelper.isJob((ImmutablePlan)plan);
    }

    public boolean isProjectSelected(String projectKey) {
        return ArrayUtils.contains((Object[])this.selectedProjects, (Object)projectKey);
    }

    public boolean isPlanSelected(String planKey) {
        return ArrayUtils.contains((Object[])this.selectedBuilds, (Object)planKey);
    }

    public List<Project> getSortedProjects() {
        if (this.projects == null) {
            this.projects = this.projectManager.getSortedProjects();
        }
        return this.projects;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public List<? extends Plan> getSortedPlans(Project project) {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.planManager.getPlansByProject(project));
    }

    public List<ImmutableTopLevelPlan> getSortedTopLevelPlans(Project project) {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().filter(PlanPredicates.withEqualProjectKey((Project)project)).sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
    }
}

