/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.ViewBuildFiles;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import java.io.File;
import org.apache.log4j.Logger;

public class DeleteBuildFiles
extends ViewBuildFiles
implements PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(DeleteBuildFiles.class);

    public String purge() throws Exception {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot delete files without a valid XSRF token");
        ImmutableResultsSummary resultsSummary = this.getImmutableBuild().getLatestResultsSummary();
        if (!this.buildExecutionManager.getCurrentlyBuilding((Key)this.getTypedPlanKey()).isEmpty()) {
            this.addActionError("Cannot purge the files while the build is being built.");
        } else {
            if (resultsSummary == null) {
                this.addActionError("Unable to find results for build..");
                return this.execute();
            }
            String buildWorkingDirectory = (String)resultsSummary.getCustomBuildData().get("working.directory");
            if (buildWorkingDirectory != null) {
                File buildWorkingDirectoryFile = new File(buildWorkingDirectory);
                this.getImmutableBuild().getBuildLogger().addBuildLogEntry("Purging files from \"" + buildWorkingDirectoryFile.getAbsolutePath() + "\"");
                BambooFileUtils.cleanDirectory((File)buildWorkingDirectoryFile);
            } else {
                this.addActionError("Cannot purge files - unable to determine build working directory.");
            }
        }
        return this.execute();
    }
}

