/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.configuration.AbstractPermissionAction;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanPermissionsService;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.actions.admin.bulk.BulkActionScope;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.apache.struts2.dispatcher.HttpParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkEditBuildPermissions
extends AbstractPermissionAction
implements GlobalAdminSecurityAware,
BulkActionScope {
    private static final Map<BambooPermission, String> PERMISSION_LABELS = ImmutableMap.of((Object)BambooPermission.READ, (Object)"build.permissions.type.view.heading", (Object)BambooPermission.WRITE, (Object)"build.permissions.type.edit.heading", (Object)BambooPermission.BUILD, (Object)"build.permissions.type.build.heading", (Object)BambooPermission.CLONE, (Object)"build.permissions.type.clone.heading", (Object)BambooPermission.ADMINISTRATION, (Object)"build.permissions.type.admin.heading");
    private long[] buildIds;
    private Collection<TopLevelPlan> selectedBuilds;
    private Map<Project, Collection<TopLevelPlan>> projectBuilds;
    private List<Project> projects;
    @Autowired
    private PlanPermissionsService planPermissionsService;

    @Override
    public String doAddUserPrincipal() throws Exception {
        BambooUser user = this.getBambooUserManager().getBambooUser(this.getNewUser());
        if (user == null) {
            this.addActionError("The user you specified is not valid.");
            return "input";
        }
        this.setNewUser(user.getUsername());
        if (!this.hasEditPermissionForUserName(this.getNewUser())) {
            this.addActionError(this.getText("user.admin.error.noSufficientRights"));
            return "input";
        }
        this.grantedPermissions.add(this.getPermissionKey("user", this.getNewUser(), (Permission)BambooPermission.READ));
        this.grantedUsers.add(this.getNewUser());
        return "input";
    }

    @Override
    public String doAddGroupPrincipal() throws Exception {
        if (this.getBambooUserManager().getGroup(this.getNewGroup()) == null) {
            this.addActionError("The group you specified is not valid");
            return "input";
        }
        if (!this.hasEditPermissionForGroup(this.getNewGroup())) {
            this.addActionError(this.getText("group.admin.error.noSufficientRights"));
            return "input";
        }
        this.grantedPermissions.add(this.getPermissionKey("group", this.getNewGroup(), (Permission)BambooPermission.READ));
        this.grantedGroups.add(this.getNewGroup());
        return "input";
    }

    public String specifyPermissions() {
        this.validateChosenBuilds();
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "input";
        }
        this.populatePermissionLists();
        return "success";
    }

    public String confirmBulkEditPermissions() throws Exception {
        if (!this.hasParameters()) {
            return "input";
        }
        this.repopulatePermissionListsFromRequest();
        String result = "Add".equals(this.getAddUserPrincipal()) || "Add".equals(this.getAddGroupPrincipal()) ? ("Group".equals(this.getPrincipalType()) ? this.doAddGroupPrincipal() : this.doAddUserPrincipal()) : this.doProceedWithSave();
        if (this.getActionErrors().isEmpty() && this.getFieldErrors().isEmpty()) {
            return result;
        }
        return "input";
    }

    public String saveBulkEditPermissions() throws Exception {
        if (!this.hasParameters()) {
            return "input";
        }
        this.repopulatePermissionListsFromRequest();
        Collection<TopLevelPlan> builds = this.getSelectedBuilds();
        for (TopLevelPlan build : builds) {
            MutableAcl acl = this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)build));
            this.aclService.updateAclAces(acl, this.grantedPermissions);
        }
        return "success";
    }

    @VisibleForTesting
    String doProceedWithSave() throws Exception {
        SetMultimap sidPermissions = MultimapBuilder.treeKeys((Comparator)BambooAcegiSecurityUtils.sidComparator()).hashSetValues().build();
        this.grantedPermissions.forEach(arg_0 -> this.lambda$doProceedWithSave$0((Multimap)sidPermissions, arg_0));
        ArrayList effectiveGrantedPermissions = new ArrayList();
        sidPermissions.asMap().forEach((sid, permissions) -> PermissionsServiceUtils.getPermissionsAndDependencies((Collection)permissions, arg_0 -> ((PlanPermissionsService)this.planPermissionsService).permissionDependencies(arg_0)).stream().map(permission -> BambooAclUpdateHelper.createPermissionKey((Sid)sid, (String)permission.getName())).forEach(effectiveGrantedPermissions::add));
        this.grantedPermissions = effectiveGrantedPermissions;
        return "success";
    }

    @Override
    @Nullable
    public MutableAcl getAcl() {
        return this.aclUpdateHelper.createNewDefaultAcl(this.getUser(), TopLevelPlan.class, false);
    }

    @Override
    @NotNull
    public String getEntityName() {
        return "plan";
    }

    @Override
    @NotNull
    public Class<?> getEntityType() {
        return TopLevelPlan.class;
    }

    @Override
    @NotNull
    public Map<String, String> getEditablePermissions() {
        return (Map)this.planPermissionsService.supportedPermissions().stream().collect(BambooCollectors.toImmutableMap(PERMISSION_LABELS::get, BambooPermission::getName));
    }

    private void repopulatePermissionListsFromRequest() {
        HttpParameters parameters = ActionContext.getContext().getParameters();
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"incorrect action call");
        if (this.grantedPermissions == null) {
            this.grantedPermissions = new ArrayList();
        }
        this.grantedUsers = new ArrayList();
        this.grantedGroups = new ArrayList();
        this.aclUpdateHelper.buildUserGroupListsFromPermissions(this.grantedPermissions, this.grantedUsers, this.grantedGroups);
    }

    private String getPermissionKey(String sidType, String sid, Permission permission) {
        String permissionName = BambooPermission.determineNameFromPermission((Permission)permission);
        return BambooAclUpdateHelper.createPermissionKey((String)sidType, (String)sid, (String)permissionName);
    }

    private void validateChosenBuilds() {
        if (this.buildIds == null || this.buildIds.length == 0) {
            this.addActionError(this.getText("build.bulkEditPermissions.plans.error.invalid"));
        }
    }

    public Collection<Project> getProjects() {
        return new ArrayList<Project>(this.getProjectBuilds().keySet());
    }

    public Collection<TopLevelPlan> getBuilds(Project project) {
        return this.getProjectBuilds().get(project);
    }

    public Map<Project, Collection<TopLevelPlan>> getProjectBuilds() {
        if (this.projectBuilds == null) {
            this.projectBuilds = this.planManager.getProjectPlanMap(TopLevelPlan.class, false);
        }
        return this.projectBuilds;
    }

    public Collection<TopLevelPlan> getSelectedBuilds() {
        if (this.selectedBuilds == null) {
            this.selectedBuilds = new ArrayList<TopLevelPlan>();
            for (long buildId : this.buildIds) {
                this.selectedBuilds.add((TopLevelPlan)this.planManager.getPlanById(buildId, TopLevelPlan.class));
            }
        }
        return this.selectedBuilds;
    }

    @Override
    public boolean isApplicableForRepositories() {
        return false;
    }

    public boolean isApplicable(BulkActionScope bulkAction, Project project) {
        return true;
    }

    @Override
    public boolean isApplicable(ImmutablePlan plan) {
        return !PlanClassHelper.isJob((ImmutablePlan)plan);
    }

    public boolean isProjectSelected(String projectKey) {
        return false;
    }

    public boolean isPlanSelected(String planKey) {
        if (this.buildIds != null) {
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
            return plan != null && Arrays.stream(this.buildIds).anyMatch(id -> id == plan.getId());
        }
        return false;
    }

    public List<Project> getSortedProjects() {
        if (this.projects == null) {
            this.projects = this.projectManager.getSortedProjects();
        }
        return this.projects;
    }

    public List<? extends Plan> getSortedPlans(Project project) {
        return Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.planManager.getPlansByProject(project));
    }

    public List<ImmutableTopLevelPlan> getSortedTopLevelPlans(Project project) {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class).stream().filter(PlanPredicates.withEqualProjectKey((Project)project)).sorted(Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toList());
    }

    public long[] getBuildIds() {
        return this.buildIds;
    }

    public void setBuildIds(long[] buildIds) {
        this.buildIds = buildIds;
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    private /* synthetic */ void lambda$doProceedWithSave$0(Multimap sidPermissions, String grantedPermission) {
        sidPermissions.put((Object)this.aclUpdateHelper.getSidFromPermissionKey(grantedPermission), (Object)((BambooPermission)this.aclUpdateHelper.getPermission(grantedPermission)));
    }
}

