/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin;

import com.atlassian.bamboo.build.creation.PlanCreationTemplate;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.utils.CommonsConfigUtils;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.event.api.EventPublisher;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class BuildConfigurationSupport
extends PlanActionSupport
implements BuildConfigurationAware {
    private static final Logger log = Logger.getLogger(BuildConfigurationSupport.class);
    protected static final String BACK = "back";
    private BuildConfiguration buildConfiguration;
    private boolean saved;
    protected UIConfigSupport uiConfigBean;
    protected EventPublisher eventPublisher;

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public String getBuildConfigurationAsXml() {
        StringWriter buildXml = new StringWriter();
        try {
            CommonsConfigUtils.sanitiseAndSave((XMLConfiguration)this.buildConfiguration.getProjectConfig(), (Writer)buildXml);
        }
        catch (ConfigurationException e) {
            log.error((Object)e, (Throwable)e);
            buildXml.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return buildXml.toString();
    }

    @Override
    public Object getSecuredDomainObject() {
        return this.getImmutablePlan();
    }

    protected String savePlan() {
        Plan plan = this.getMutablePlan();
        if (this.buildConfiguration == null) {
            this.addActionError("Unable to update current configuration. No configuration was found.");
            return "error";
        }
        if (plan == null) {
            this.addActionError("Unable to update current configuration. No plan was found.");
            return "error";
        }
        PlanCreationTemplate.cleanBuildConfiguration((BuildConfiguration)this.buildConfiguration);
        this.buildDefinitionManager.savePlanAndDefinition(plan, this.buildConfiguration);
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, plan.getPlanKey()));
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
        log.info((Object)("Build configuration for '" + plan.getKey() + "' saved."));
        return "success";
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigBean;
    }

    public void setUiConfigBean(UIConfigSupport uiConfigBean) {
        this.uiConfigBean = uiConfigBean;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

