/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.PaginationAware;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewBuildResultsTable
extends BambooActionSupport
implements PaginationAware {
    private static final Logger log = Logger.getLogger(ViewBuildResultsTable.class);
    private List<? extends BuildResultsSummary> resultsList;
    private Map<Long, PipelineDefinition> pipelineDefinitionMap;
    private boolean sort = false;
    private boolean showOperations = false;
    private boolean showAgent = false;
    private Integer maxBuilds;
    private boolean singlePlan = false;
    private Pager pager;
    @Autowired
    private AgentManager agentManager;
    @Autowired
    ArtifactLinkManager artifactLinkManager;

    public String execute() throws Exception {
        if (this.isSort()) {
            this.sortResults(this.resultsList);
        }
        return "success";
    }

    @Override
    public List<? extends BuildResultsSummary> getResultsList() {
        return this.resultsList;
    }

    protected void sortResults(List<? extends BuildResultsSummary> resultsList) {
        if (this.singlePlan) {
            Collections.sort(resultsList, Collections.reverseOrder(Comparators.getResultsSummaryNumberOrdering()));
        } else {
            Collections.sort(resultsList, Collections.reverseOrder(Comparators.getBuildCompletedDateComparator()));
        }
    }

    public void setResultsList(List<? extends BuildResultsSummary> results) {
        this.resultsList = results;
    }

    public PipelineDefinition getPipelineDefinitionByBuildResult(BuildResultsSummary buildResultsSummary) {
        if (this.pipelineDefinitionMap == null) {
            Collection<Object> agentIds = Collections.emptyList();
            if (this.pager.getPage().getList() != null) {
                agentIds = Collections2.transform(this.pager.getPage().getList(), (Function)new Function<BuildResultsSummary, Long>(){

                    public Long apply(BuildResultsSummary from) {
                        return from.getBuildAgentId();
                    }
                });
            }
            this.pipelineDefinitionMap = new HashMap<Long, PipelineDefinition>();
            Map agents = this.agentManager.findAllAgentsForAgentIds(agentIds);
            for (Map.Entry entry : agents.entrySet()) {
                this.pipelineDefinitionMap.put((Long)entry.getKey(), (PipelineDefinition)entry.getValue());
            }
        }
        return this.pipelineDefinitionMap.get(buildResultsSummary.getBuildAgentId());
    }

    @Nullable
    public final String getArtifactLinkUrl(ArtifactLink artifactLink) {
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifactLinkManager, (Artifact)artifactLink.getArtifact(), (String)this.getBambooUrl().rootContext());
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public Pager getPager() {
        return this.pager;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public Integer getMaxBuilds() {
        return this.maxBuilds;
    }

    public void setMaxBuilds(Integer maxBuilds) {
        this.maxBuilds = maxBuilds;
    }

    public boolean isShowAgent() {
        return this.showAgent;
    }

    public void setShowAgent(boolean showAgent) {
        this.showAgent = showAgent;
    }

    public boolean isSinglePlan() {
        return this.singlePlan;
    }

    public void setSinglePlan(boolean singlePlan) {
        this.singlePlan = singlePlan;
    }
}

