/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.ww2.actions.agent.BuildAgentDecorator;
import com.atlassian.bamboo.ww2.actions.build.AbstractBuildJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.BuildQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.DeploymentQueueItemViewForJsonDecorator;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class QueuedBuildJsonDecorator
extends AbstractBuildJsonDecorator {
    private static final Logger log = Logger.getLogger(QueuedBuildJsonDecorator.class);
    private List<BuildAgentDecorator> executableBuildAgents = Collections.emptyList();
    private List<ElasticImageConfiguration> executableElasticImages = Collections.emptyList();
    private final int queueIndex;
    private CurrentlyBuilding currentlyBuilding;

    public QueuedBuildJsonDecorator(@NotNull TextProvider textProvider, @NotNull BuildQueueItemViewForJsonDecorator buildQueueItem, int index, AgentManager agentManager, @NotNull BuildExecutionManager buildExecutionManager, @NotNull BambooPermissionManager bambooPermissionManager, TriggerManager triggerManager, Collection<ElasticImageConfiguration> imagesForExecutable, Set<Long> agentsForExecutable) {
        super(textProvider, bambooPermissionManager, buildQueueItem, triggerManager);
        this.queueIndex = index;
        if (!this.hasReadPermission) {
            this.messageText = textProvider.getText("queue.hidden.build.status");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
            return;
        }
        this.currentlyBuilding = buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)buildQueueItem.getJobResultKey());
        if (this.currentlyBuilding == null) {
            log.warn((Object)("Could not get CurrentlyBuilding for [" + buildQueueItem.getChainResultKey() + "]"));
            return;
        }
        if (!agentsForExecutable.isEmpty()) {
            this.messageText = textProvider.getText("queue.status.waiting");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
            this.executableBuildAgents = agentsForExecutable.stream().map(arg_0 -> ((AgentManager)agentManager).getAgent(arg_0)).filter(Objects::nonNull).map(BuildAgentDecorator::new).collect(Collectors.toList());
        } else {
            this.messageText = textProvider.getText("queue.status.cantBuild");
            this.messageType = AbstractBuildJsonDecorator.MessageType.ERROR;
        }
        this.executableElasticImages = new ArrayList<ElasticImageConfiguration>(imagesForExecutable);
    }

    public QueuedBuildJsonDecorator(@NotNull TextProvider textProvider, @NotNull DeploymentQueueItemViewForJsonDecorator deploymentQueueItem, int index, @NotNull EnvironmentService environmentService, TriggerManager triggerManager, Collection<ElasticImageConfiguration> imagesForExecutable, Set<Long> agentsForExecutable) {
        super(textProvider, environmentService, deploymentQueueItem, triggerManager);
        this.queueIndex = index;
        if (!this.hasReadPermission) {
            this.messageText = textProvider.getText("queue.hidden.deployment.status");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
            return;
        }
        if (deploymentQueueItem.getExecutableAgents().isEmpty()) {
            this.messageText = textProvider.getText("queue.status.cantDeploy");
            this.messageType = AbstractBuildJsonDecorator.MessageType.ERROR;
        } else {
            this.messageText = textProvider.getText("queue.status.deployment.waiting");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
        }
        this.executableElasticImages = new ArrayList<ElasticImageConfiguration>(deploymentQueueItem.getExecutableElasticImages());
        this.executableBuildAgents = new ArrayList<BuildAgentDecorator>(deploymentQueueItem.getExecutableAgents());
    }

    public void getJson(JsonStream jsonBuildObject) throws IOException, JSONException {
        jsonBuildObject.writeStartObject();
        this.getBaseJson(jsonBuildObject);
        if (this.currentlyBuilding != null) {
            jsonBuildObject.put("triggerReason", this.triggerManager.getTriggerReasonRenderer(this.queueItem.getTriggerReason(), this.currentlyBuilding).getShortDescriptionText());
        } else {
            jsonBuildObject.put("triggerReason", this.queueItem.getTriggerReason().getName());
        }
        if (!this.executableBuildAgents.isEmpty()) {
            ArrayList<JSONObject> jsonAgents = new ArrayList<JSONObject>();
            for (BuildAgentDecorator agent : this.executableBuildAgents) {
                jsonAgents.add(agent.getJson());
            }
            jsonBuildObject.put("executableAgents", jsonAgents);
        }
        if (!this.executableElasticImages.isEmpty()) {
            ArrayList<JSONObject> jsonElasticImages = new ArrayList<JSONObject>();
            for (ElasticImageConfiguration elasticImageConfiguration : this.executableElasticImages) {
                JSONObject jsonElasticImageObject = new JSONObject();
                jsonElasticImageObject.put("id", elasticImageConfiguration.getId());
                jsonElasticImageObject.put("name", (Object)elasticImageConfiguration.getConfigurationName());
                jsonElasticImages.add(jsonElasticImageObject);
            }
            jsonBuildObject.put("executableElasticImages", jsonElasticImages);
        }
        if (this.queueIndex > -1) {
            jsonBuildObject.put("queueIndex", this.queueIndex);
        }
        jsonBuildObject.writeEndObject();
    }
}

