/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.actions.agent.BuildAgentDecorator;
import com.atlassian.bamboo.ww2.actions.build.AbstractBuildJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.DeploymentQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentlyDeployingJsonDecorator
extends AbstractBuildJsonDecorator {
    private static final Logger log = Logger.getLogger(CurrentlyDeployingJsonDecorator.class);
    private final BuildAgentDecorator buildAgent;
    private final boolean isBeingStopped;

    public CurrentlyDeployingJsonDecorator(@NotNull DeploymentInProgress deploymentInProgress, @NotNull TextProvider textProvider, @NotNull EnvironmentService environmentService, TriggerManager triggerManager, @NotNull AgentManager agentManager) {
        super(textProvider, environmentService, new DeploymentQueueItemViewForJsonDecorator(deploymentInProgress.getResultId(), deploymentInProgress.getResultKey().getKey(), deploymentInProgress.getDeploymentVersionId(), deploymentInProgress.getDeploymentVersionName(), deploymentInProgress.getEnvironmentId(), deploymentInProgress.getEnvironmentName(), deploymentInProgress.getDeploymentProjectName(), QueueItemViewForJsonDecorator.BuildStatus.BUILDING, deploymentInProgress.getTriggerReason(), Collections.emptyList(), Collections.emptyList()), triggerManager);
        this.isBeingStopped = deploymentInProgress.isBeingStopped();
        if (this.hasReadPermission) {
            this.buildAgent = this.getBuildAgent(agentManager, deploymentInProgress.getAgentId());
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
            this.messageText = textProvider.getText("deployment.currentactivity.duration", new String[]{DurationUtils.getPrettyPrint((long)(new Date().getTime() - deploymentInProgress.getExecutedDate().getTime()), (boolean)false)});
        } else {
            this.buildAgent = null;
            this.messageText = textProvider.getText("queue.hidden.deployment.status");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
        }
    }

    @Nullable
    private BuildAgentDecorator getBuildAgent(@NotNull AgentManager agentManager, @Nullable Long agentId) {
        if (agentId == null) {
            return null;
        }
        BuildAgent agent = agentManager.getAgent(agentId.longValue());
        return agent != null ? new BuildAgentDecorator(agent) : null;
    }

    public void getJson(JsonStream jsonBuildObject) throws IOException, JSONException {
        jsonBuildObject.writeStartObject();
        this.getBaseJson(jsonBuildObject);
        jsonBuildObject.put("triggerReason", this.triggerManager.getTriggerReasonRenderer(this.queueItem.getTriggerReason()).getShortDescriptionText());
        if (this.buildAgent != null) {
            jsonBuildObject.put("agent", this.buildAgent.getJson());
        }
        if (this.isBeingStopped) {
            jsonBuildObject.put("isBeingStopped", true);
        }
        jsonBuildObject.writeEndObject();
    }
}

