/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.actions.agent.BuildAgentDecorator;
import com.atlassian.bamboo.ww2.actions.build.AbstractBuildJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.BuildQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CurrentlyBuildingJsonDecorator
extends AbstractBuildJsonDecorator {
    private static final Logger log = Logger.getLogger(CurrentlyBuildingJsonDecorator.class);
    private final BuildAgentDecorator buildAgent;
    private final double percentageComplete;
    private boolean isBeingStopped = false;
    private final CurrentlyBuilding currentlyBuilding;

    public CurrentlyBuildingJsonDecorator(@NotNull TextProvider textProvider, @NotNull CurrentlyBuilding currentlyBuilding, @NotNull AgentManager agentManager, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull TriggerManager triggerManager, @NotNull ImmutablePlan plan) {
        super(textProvider, bambooPermissionManager, new BuildQueueItemViewForJsonDecorator(currentlyBuilding.getBuildIdentifier().getParentBuildIdentifier().getTypedPlanKey(), currentlyBuilding.getBuildIdentifier().getProjectName(), currentlyBuilding.getBuildIdentifier().getParentBuildIdentifier().getShortName(), currentlyBuilding.getBuildIdentifier().getParentBuildIdentifier().getPlanName(), currentlyBuilding.getBuildIdentifier().getTypedPlanKey(), currentlyBuilding.getBuildIdentifier().getShortName(), currentlyBuilding.getBuildIdentifier().getPlanResultKey(), currentlyBuilding.getBuildIdentifier().getParentBuildIdentifier().getPlanResultKey(), currentlyBuilding.getBuildIdentifier().getBuildNumber(), QueueItemViewForJsonDecorator.BuildStatus.BUILDING, currentlyBuilding.getTriggerReason(), plan.hasMaster()), triggerManager);
        this.currentlyBuilding = currentlyBuilding;
        if (this.hasReadPermission) {
            BuildAgent agent;
            Long buildAgentId = currentlyBuilding.getBuildAgentId();
            this.buildAgent = buildAgentId != null ? ((agent = agentManager.getAgent(buildAgentId.longValue())) != null ? new BuildAgentDecorator(agent) : null) : null;
            if (currentlyBuilding.getElapsedTime() > 0L) {
                if (currentlyBuilding.getBuildHangDetails() != null) {
                    this.messageText = textProvider.getText("build.currentactivity.build.hung", new String[]{DurationUtils.getPrettyPrint((long)currentlyBuilding.getElapsedTime(), (boolean)false)});
                    this.messageType = AbstractBuildJsonDecorator.MessageType.ERROR;
                    this.percentageComplete = 0.0;
                } else if (currentlyBuilding.getBuildCancelledDetails() != null) {
                    this.messageText = textProvider.getText("build.currentactivity.build.beingstopped");
                    this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
                    this.percentageComplete = 0.0;
                    this.isBeingStopped = true;
                } else {
                    this.messageText = currentlyBuilding.getProgressBar().isUnderAverageTime() ? textProvider.getText("build.currentactivity.build.underaverage", new String[]{DurationUtils.getPrettyPrint((long)currentlyBuilding.getElapsedTime(), (boolean)false), currentlyBuilding.getProgressBar().getPrettyTimeRemaining(false)}) : textProvider.getText("build.currentactivity.build.overaverage", new String[]{DurationUtils.getPrettyPrint((long)currentlyBuilding.getElapsedTime(), (boolean)false)});
                    this.messageType = AbstractBuildJsonDecorator.MessageType.PROGRESS;
                    this.percentageComplete = currentlyBuilding.getProgressBar().getPercentageCompleted();
                }
            } else {
                String vcsRevisionKey = "latest";
                this.messageText = textProvider.getText("build.currentactivity.build.updatingsource", new String[]{"latest"});
                this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
                this.percentageComplete = 0.0;
            }
        } else {
            this.buildAgent = null;
            this.percentageComplete = 0.0;
            this.messageText = textProvider.getText("queue.hidden.build.status");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
        }
    }

    public void getJson(JsonStream jsonBuildObject) throws IOException, JSONException {
        jsonBuildObject.writeStartObject();
        this.getBaseJson(jsonBuildObject);
        jsonBuildObject.put("triggerReason", this.triggerManager.getTriggerReasonRenderer(this.queueItem.getTriggerReason(), this.currentlyBuilding).getShortDescriptionText());
        if (this.buildAgent != null) {
            jsonBuildObject.put("agent", this.buildAgent.getJson());
        }
        if (this.messageType == AbstractBuildJsonDecorator.MessageType.PROGRESS) {
            if (Double.isNaN(this.percentageComplete) || Double.isInfinite(this.percentageComplete)) {
                jsonBuildObject.put("percentageComplete", 0);
            } else {
                jsonBuildObject.put("percentageComplete", Math.floor(this.percentageComplete * 100.0));
            }
        }
        if (this.isBeingStopped) {
            jsonBuildObject.put("isBeingStopped", true);
        }
        jsonBuildObject.writeEndObject();
    }
}

