/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.struts.JsonStreamingAction;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.ChainExecutionJsonDecorator;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalReadSecurityAware;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ChainJsonProviderAction
extends ActionSupport
implements GlobalReadSecurityAware,
PlanAware,
JsonStreamingAction {
    private static final Logger log = Logger.getLogger(ChainJsonProviderAction.class);
    private String planKey;
    private ChainExecutionManager chainExecutionManager;
    private ResultsSummaryManager resultsSummaryManager;
    private TextProvider textProvider;
    private TriggerManager triggerManager;
    private BambooPermissionManager bambooPermissionManager;
    private ImmutablePlan plan;

    @Override
    public void streamJson(JsonStream jsonObject) throws IOException, JSONException {
        jsonObject.put("status", (Object)BambooActionSupport.JSONStatus.OK);
        jsonObject.writeArrayFieldStart("builds");
        List executingBuilds = this.chainExecutionManager.getExecutingChains(PlanKeys.getPlanKey((String)this.planKey)).stream().sorted(Comparator.comparing(e -> e.getPlanResultKey().getKey())).collect(Collectors.toList());
        for (ChainExecution build : executingBuilds) {
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(build.getPlanResultKey());
            ChainExecutionJsonDecorator chainExecutionJsonDecorator = new ChainExecutionJsonDecorator(this.textProvider, this.bambooPermissionManager, build, resultsSummary, this.triggerManager);
            chainExecutionJsonDecorator.getJson(jsonObject);
        }
        jsonObject.writeEndArray();
    }

    public void setChainExecutionManager(ChainExecutionManager chainExecutionManager) {
        this.chainExecutionManager = chainExecutionManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public void setBambooPermissionManager(BambooPermissionManager bambooPermissionManager) {
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @Override
    public Object getSecuredDomainObject() {
        return this.plan;
    }

    @Override
    public ImmutablePlan getImmutablePlan() {
        return null;
    }

    @Override
    public Plan getMutablePlan() {
        return null;
    }

    @Override
    public Plan getPlan() {
        return null;
    }

    @Override
    public void setPlan(ImmutablePlan plan) {
        this.plan = plan;
    }
}

