/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.ww2.actions.build.AbstractBuildJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.BuildQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.StageJsonDecorator;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ChainExecutionJsonDecorator
extends AbstractBuildJsonDecorator {
    private final double percentageComplete;
    private boolean isBeingStopped;
    private StageJsonDecorator stageJsonDecorator;
    private final ResultsSummary chainResultSummary;

    public ChainExecutionJsonDecorator(@NotNull TextProvider textProvider, @NotNull BambooPermissionManager bambooPermissionManager, ChainExecution chainExecution, ResultsSummary chainResultSummary, TriggerManager triggerManager) {
        super(textProvider, bambooPermissionManager, new BuildQueueItemViewForJsonDecorator(chainResultSummary.getPlanKey(), chainResultSummary.getImmutablePlan().getProject().getName(), chainResultSummary.getImmutablePlan().getBuildName(), chainExecution.getName(), null, null, chainResultSummary.getPlanResultKey(), null, chainResultSummary.getBuildNumber(), chainResultSummary.getLifeCycleState() == LifeCycleState.QUEUED ? QueueItemViewForJsonDecorator.BuildStatus.QUEUED : QueueItemViewForJsonDecorator.BuildStatus.BUILDING, chainResultSummary.getTriggerReason(), chainResultSummary.getImmutablePlan().hasMaster()), triggerManager);
        this.chainResultSummary = chainResultSummary;
        StageExecution stageExecution = chainExecution.getCurrentStage();
        ChainResultsSummary results = (ChainResultsSummary)Narrow.to((Object)chainResultSummary, ChainResultsSummary.class);
        if (stageExecution != null) {
            this.stageJsonDecorator = chainResultSummary.getRestartCount() >= 1 && results != null ? new StageJsonDecorator(chainExecution, stageExecution, results.getStageResults()) : new StageJsonDecorator(chainExecution, stageExecution, null);
        }
        if (this.hasReadPermission) {
            this.isBeingStopped = chainExecution.isStopping();
            if (this.isBeingStopped) {
                this.messageText = textProvider.getText("build.currentactivity.build.beingstopped");
                this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
                this.percentageComplete = 0.0;
            } else if (chainResultSummary.getLifeCycleState() == LifeCycleState.QUEUED) {
                this.messageText = textProvider.getText("build.currentactivity.waiting");
                this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
                this.percentageComplete = 0.0;
            } else {
                this.messageType = AbstractBuildJsonDecorator.MessageType.PROGRESS;
                this.messageText = chainExecution.getProgressBar().isUnderAverageTime() ? textProvider.getText("build.currentactivity.build.underaverage", new String[]{DurationUtils.getPrettyPrint((long)chainExecution.getElapsedTime(), (boolean)false), chainExecution.getProgressBar().getPrettyTimeRemaining(false)}) : textProvider.getText("build.currentactivity.build.overaverage", new String[]{DurationUtils.getPrettyPrint((long)chainExecution.getElapsedTime(), (boolean)false)});
                this.messageType = AbstractBuildJsonDecorator.MessageType.PROGRESS;
                this.percentageComplete = chainExecution.getProgressBar().getPercentageCompleted();
            }
        } else {
            this.percentageComplete = 0.0;
            this.messageText = textProvider.getText("queue.hidden.build.status");
            this.messageType = AbstractBuildJsonDecorator.MessageType.INFORMATIVE;
        }
    }

    public void getJson(JsonStream jsonBuildObject) throws JSONException, IOException {
        jsonBuildObject.writeStartObject();
        this.getBaseJson(jsonBuildObject);
        jsonBuildObject.put("triggerReason", this.triggerManager.getTriggerReasonRenderer(this.queueItem.getTriggerReason(), this.chainResultSummary).getShortDescriptionText());
        if (this.messageType == AbstractBuildJsonDecorator.MessageType.PROGRESS) {
            if (Double.isNaN(this.percentageComplete) || Double.isInfinite(this.percentageComplete)) {
                jsonBuildObject.put("percentageComplete", 0);
            } else {
                jsonBuildObject.put("percentageComplete", Math.floor(this.percentageComplete * 100.0));
            }
        }
        if (this.stageJsonDecorator != null) {
            jsonBuildObject.put("stage", this.stageJsonDecorator.getJson());
        }
        if (this.isBeingStopped) {
            jsonBuildObject.put("isBeingStopped", true);
        }
        jsonBuildObject.writeEndObject();
    }
}

