/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.QueueManagerView;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.agent.BuildAgentDecorator;
import com.atlassian.bamboo.ww2.actions.build.BuildQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.CurrentlyBuildingJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.CurrentlyDeployingJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.DeploymentQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueuedBuildJsonDecorator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class BuildJsonProviderAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(BuildJsonProviderAction.class);
    private static final Comparator<CurrentlyBuilding> ORDER_BY_VCS_UPDATE_TIME = Comparator.comparing(CurrentlyBuilding::getVcsUpdateTime, Comparator.nullsLast(Comparator.naturalOrder()));
    private boolean showBuilding = true;
    private boolean showQueued = true;
    private String planKey;
    private BuildExecutionManager buildExecutionManager;
    @Autowired
    private EnvironmentService environmentService;
    private DeploymentsInProgressService deploymentsInProgressService;
    protected AgentManager agentManager;
    private TextProvider textProvider;
    private TriggerManager triggerManager;
    private QueueManagerView<CommonContext, QueueItemViewForJsonDecorator> queueManagerView;
    @Autowired
    private BuildQueueManager queueManager;
    private ExecutableAgentsHelper executableAgentsHelper;
    static volatile Iterable<BuildQueueManager.QueueItemView<QueueItemViewForJsonDecorator>> queueView = Collections.emptyList();

    private BuildQueueManager.QueueItemView<QueueItemViewForJsonDecorator> commonContext2QueueItem(BuildQueueManager.QueueItemView<CommonContext> buildContextView) {
        CommonContext commonContext = (CommonContext)buildContextView.getView();
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        if (buildContext != null) {
            return this.newQueueItemView(buildContextView.getQueuedResultKey(), buildContext);
        }
        DeploymentContext deploymentContext = (DeploymentContext)Narrow.downTo((Object)commonContext, DeploymentContext.class);
        if (deploymentContext != null) {
            return this.newQueueItemView(buildContextView.getQueuedResultKey(), deploymentContext);
        }
        throw new IllegalStateException("Neither build or deployment: " + commonContext.getClass());
    }

    @NotNull
    private BuildQueueManager.QueueItemView<QueueItemViewForJsonDecorator> newQueueItemView(BuildQueueManager.QueuedResultKey queuedResultKey, DeploymentContext deploymentContext) {
        List<ElasticImageConfiguration> elasticImageConfigurations;
        List<BuildAgentDecorator> executableAgents;
        RequirementSet requirementSet = this.environmentService.getEnvironmentRequirementSet(deploymentContext.getEnvironmentId());
        if (requirementSet != null) {
            Collection executableBuildAgents = this.executableAgentsHelper.getExecutableAgents(ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)requirementSet, (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((CommonContext)deploymentContext)));
            executableAgents = executableBuildAgents.stream().map(arg_0 -> BuildAgentDecorator.toDecorator.apply(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            elasticImageConfigurations = new ArrayList<ElasticImageConfiguration>(this.executableAgentsHelper.getExecutableImages(ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)requirementSet, (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((CommonContext)deploymentContext))));
        } else {
            elasticImageConfigurations = Collections.emptyList();
            executableAgents = Collections.emptyList();
        }
        DeploymentQueueItemViewForJsonDecorator view = new DeploymentQueueItemViewForJsonDecorator(deploymentContext.getDeploymentResultId(), deploymentContext.getResultKey().getKey(), deploymentContext.getDeploymentVersion().getId(), deploymentContext.getDeploymentVersion().getName(), deploymentContext.getEnvironmentId(), deploymentContext.getEnvironmentName(), deploymentContext.getDeploymentProjectName(), QueueItemViewForJsonDecorator.BuildStatus.QUEUED, deploymentContext.getTriggerReason(), executableAgents, elasticImageConfigurations);
        return new BuildQueueManager.QueueItemView(queuedResultKey, (Object)view);
    }

    @NotNull
    private BuildQueueManager.QueueItemView<QueueItemViewForJsonDecorator> newQueueItemView(BuildQueueManager.QueuedResultKey queuedResultKey, BuildContext buildContext) {
        BuildQueueItemViewForJsonDecorator view = new BuildQueueItemViewForJsonDecorator(buildContext.getParentBuildContext().getTypedPlanKey(), buildContext.getProjectName(), buildContext.getParentBuildContext().getShortName(), buildContext.getParentBuildContext().getPlanName(), buildContext.getTypedPlanKey(), buildContext.getShortName(), buildContext.getPlanResultKey(), buildContext.getParentBuildContext().getPlanResultKey(), buildContext.getBuildNumber(), QueueItemViewForJsonDecorator.BuildStatus.QUEUED, buildContext.getTriggerReason(), buildContext.getParentBuildContext().isBranch());
        return new BuildQueueManager.QueueItemView(queuedResultKey, (Object)view);
    }

    @Override
    public void streamJson(JsonStream stream) throws IOException, JSONException {
        super.streamJson(stream);
        stream.writeArrayFieldStart("builds");
        if (this.showBuilding) {
            this.streamBuildsInProgress(stream);
        }
        if (this.showQueued) {
            this.streamQueuedBuilds(stream);
        }
        stream.writeEndArray();
    }

    private void streamQueuedBuilds(JsonStream stream) throws IOException, JSONException {
        queueView = this.queueManagerView.getQueueView(queueView);
        int index = 0;
        boolean shouldFilter = StringUtils.isNotEmpty((CharSequence)this.planKey);
        for (BuildQueueManager.QueueItemView<QueueItemViewForJsonDecorator> queuedItem : queueView) {
            if (shouldFilter && !StringUtils.equals((CharSequence)queuedItem.getQueuedResultKey().getResultKey().getEntityKey().toString(), (CharSequence)this.planKey)) continue;
            Collection imagesForExecutable = this.queueManager.getImagesForQueuedExecutable(queuedItem.getQueuedResultKey().getResultKey());
            Set agentsForExecutable = this.queueManager.getExecutorsForQueuedExecutable(queuedItem.getQueuedResultKey().getResultKey());
            if (imagesForExecutable == null || agentsForExecutable == null) continue;
            ++index;
            BuildQueueItemViewForJsonDecorator queuedBuild = (BuildQueueItemViewForJsonDecorator)Narrow.downTo((Object)queuedItem.getView(), BuildQueueItemViewForJsonDecorator.class);
            if (queuedBuild != null) {
                QueuedBuildJsonDecorator buildJsonDecorator = new QueuedBuildJsonDecorator(this.textProvider, queuedBuild, index, this.agentManager, this.buildExecutionManager, this.bambooPermissionManager, this.triggerManager, imagesForExecutable, agentsForExecutable);
                buildJsonDecorator.getJson(stream);
                continue;
            }
            DeploymentQueueItemViewForJsonDecorator queuedDeployment = (DeploymentQueueItemViewForJsonDecorator)Narrow.downTo((Object)queuedItem.getView(), DeploymentQueueItemViewForJsonDecorator.class);
            if (queuedDeployment != null) {
                QueuedBuildJsonDecorator deploymentJsonDecorator = new QueuedBuildJsonDecorator(this.textProvider, queuedDeployment, index, this.environmentService, this.triggerManager, imagesForExecutable, agentsForExecutable);
                deploymentJsonDecorator.getJson(stream);
                continue;
            }
            log.error((Object)"Neither deployment nor build?");
            throw new IllegalStateException("Neither deployment nor build?");
        }
    }

    private void streamBuildsInProgress(JsonStream stream) throws IOException, JSONException {
        Iterable executingBuilds = StringUtils.isEmpty((CharSequence)this.planKey) ? this.buildExecutionManager.getCurrentlyExecuting() : this.buildExecutionManager.getCurrentlyExecuting(PlanKeys.getPlanKey((String)this.planKey));
        for (CurrentlyBuilding build : Ordering.from(ORDER_BY_VCS_UPDATE_TIME).sortedCopy(executingBuilds)) {
            BuildIdentifier parentPlan;
            ImmutableChain plan;
            if (build.isCurrentlyQueuedOnly() || (plan = (ImmutableChain)this.cachedPlanManager.getPlanByKey((parentPlan = (BuildIdentifier)Preconditions.checkNotNull((Object)build.getBuildIdentifier().getParentBuildIdentifier(), (Object)("getCurrentlyExecutingBuilds returned plan level CurrentlyBuilding. " + build.getBuildIdentifier().getBuildResultKey()))).getPlanResultKey().getPlanKey(), ImmutableChain.class)) == null) continue;
            CurrentlyBuildingJsonDecorator currentlyBuildingJsonDecorator = new CurrentlyBuildingJsonDecorator(this.textProvider, build, this.agentManager, this.bambooPermissionManager, this.triggerManager, (ImmutablePlan)plan);
            currentlyBuildingJsonDecorator.getJson(stream);
        }
        if (StringUtils.isEmpty((CharSequence)this.planKey)) {
            for (DeploymentInProgress deploymentInProgress : this.deploymentsInProgressService.getDeploymentsInProgress()) {
                CurrentlyDeployingJsonDecorator deployingJsonDecorator = new CurrentlyDeployingJsonDecorator(deploymentInProgress, this.textProvider, this.environmentService, this.triggerManager, this.agentManager);
                deployingJsonDecorator.getJson(stream);
            }
        }
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.queueManager = buildQueueManager;
        this.queueManagerView = QueueManagerView.newView((BuildQueueManager)buildQueueManager, this::commonContext2QueueItem);
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setShowBuilding(boolean showBuilding) {
        this.showBuilding = showBuilding;
    }

    public void setShowQueued(boolean showQueued) {
        this.showQueued = showQueued;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }

    public void setExecutableAgentsHelper(ExecutableAgentsHelper executableAgentsHelper) {
        this.executableAgentsHelper = executableAgentsHelper;
    }

    public void setDeploymentsInProgressService(DeploymentsInProgressService deploymentsInProgressService) {
        this.deploymentsInProgressService = deploymentsInProgressService;
    }
}

