/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build;

import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.struts.JsonStream;
import com.atlassian.bamboo.ww2.actions.build.BuildQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.DeploymentQueueItemViewForJsonDecorator;
import com.atlassian.bamboo.ww2.actions.build.QueueItemViewForJsonDecorator;
import com.opensymphony.xwork2.TextProvider;
import java.io.IOException;
import java.util.Collections;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AbstractBuildJsonDecorator {
    private static final Logger log = Logger.getLogger(AbstractBuildJsonDecorator.class);
    protected final TriggerManager triggerManager;
    protected final QueueItemViewForJsonDecorator queueItem;
    protected final boolean hasReadPermission;
    protected final boolean hasBuildPermission;
    protected MessageType messageType;
    protected String messageText;

    public AbstractBuildJsonDecorator(@NotNull TextProvider textProvider, @NotNull BambooPermissionManager bambooPermissionManager, @NotNull BuildQueueItemViewForJsonDecorator buildQueueItem, TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
        this.hasReadPermission = bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.READ, buildQueueItem.getChainKey());
        this.hasBuildPermission = bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.BUILD, buildQueueItem.getChainKey());
        this.queueItem = this.hasReadPermission ? buildQueueItem : new BuildQueueItemViewForJsonDecorator(buildQueueItem.getChainKey(), null, textProvider.getText("queue.hidden.build.waiting"), null, buildQueueItem.getTypedJobKey(), null, buildQueueItem.getJobResultKey(), buildQueueItem.getChainResultKey(), buildQueueItem.getBuildNumber(), QueueItemViewForJsonDecorator.BuildStatus.QUEUED, buildQueueItem.getTriggerReason(), buildQueueItem.isBranch());
    }

    public AbstractBuildJsonDecorator(@NotNull TextProvider textProvider, @NotNull EnvironmentService environmentService, @NotNull DeploymentQueueItemViewForJsonDecorator deploymentQueueItem, TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
        Environment environment = null;
        try {
            environment = environmentService.getEnvironment(deploymentQueueItem.getEnvironmentId());
        }
        catch (Exception e) {
            log.trace(null, (Throwable)e);
        }
        this.hasReadPermission = environment != null && environment.getOperations().isCanView();
        this.hasBuildPermission = environment != null && environment.getOperations().isAllowedToExecute();
        this.queueItem = this.hasReadPermission ? deploymentQueueItem : new DeploymentQueueItemViewForJsonDecorator(deploymentQueueItem.getResultId(), deploymentQueueItem.getResultKey(), deploymentQueueItem.getVersionId(), textProvider.getText("queue.hidden.deployment.waiting"), deploymentQueueItem.getEnvironmentId(), null, null, QueueItemViewForJsonDecorator.BuildStatus.QUEUED, deploymentQueueItem.getTriggerReason(), Collections.emptyList(), Collections.emptyList());
    }

    protected void getBaseJson(JsonStream jsonBuildObject) throws IOException {
        jsonBuildObject.put("status", (Object)this.queueItem.getBuildStatus());
        jsonBuildObject.put("messageType", (Object)this.messageType);
        jsonBuildObject.put("messageText", this.messageText);
        jsonBuildObject.put("hasReadPermission", this.hasReadPermission);
        jsonBuildObject.put("hasBuildPermission", this.hasBuildPermission);
        jsonBuildObject.put("itemType", this.queueItem.getItemType().name());
        jsonBuildObject.put("resultKey", this.queueItem.getResultKey());
        switch (this.queueItem.getItemType()) {
            case BUILD: {
                BuildQueueItemViewForJsonDecorator buildQueueItem = (BuildQueueItemViewForJsonDecorator)this.queueItem;
                jsonBuildObject.put("buildResultKey", buildQueueItem.getJobResultKey());
                jsonBuildObject.putIfNotNull("planResultKey", buildQueueItem.getChainResultKey());
                jsonBuildObject.put("planKey", buildQueueItem.getChainKey());
                jsonBuildObject.putIfNotNull("jobKey", buildQueueItem.getTypedJobKey());
                jsonBuildObject.putIfNotNull("projectName", buildQueueItem.getProjectName());
                jsonBuildObject.put("chainName", buildQueueItem.getChainName());
                jsonBuildObject.putIfNotNull("jobName", buildQueueItem.getJobName());
                jsonBuildObject.putIfNotNull("planName", buildQueueItem.getPlanName());
                jsonBuildObject.put("buildNumber", buildQueueItem.getBuildNumber());
                jsonBuildObject.put("isBranch", buildQueueItem.isBranch());
                break;
            }
            case DEPLOYMENT: {
                DeploymentQueueItemViewForJsonDecorator deploymentQueueItem = (DeploymentQueueItemViewForJsonDecorator)this.queueItem;
                jsonBuildObject.put("resultId", deploymentQueueItem.getResultId());
                jsonBuildObject.put("environmentId", deploymentQueueItem.getEnvironmentId());
                jsonBuildObject.putIfNotNull("environmentName", deploymentQueueItem.getEnvironmentName());
                jsonBuildObject.putIfNotNull("deploymentProjectName", deploymentQueueItem.getDeploymentProjectName());
                jsonBuildObject.put("versionId", deploymentQueueItem.getVersionId());
                jsonBuildObject.put("versionName", deploymentQueueItem.getVersionName());
                break;
            }
            default: {
                throw new IllegalStateException("Neither build nor deployment");
            }
        }
    }

    protected static enum MessageType {
        ERROR,
        INFORMATIVE,
        PROGRESS;

    }
}

