/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.ww2.actions.build.admin.config.repository.ConfigureRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class EditChainBranchRepository
extends ConfigureRepository {
    private static final Logger log = Logger.getLogger(EditChainBranchRepository.class);
    private boolean overrideRepositoryLocation;
    private boolean resetDone;
    private boolean parentRemoved;
    private String selectedRepository;
    private boolean defaultRepositoryTypeDifferent;
    private boolean isDefaultRepository;
    protected PlanRepositoryDefinition parentRepository;
    @Autowired
    private RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeSelector;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> currentViewersSelectors;

    @Override
    public void prepare() throws Exception {
        this.repositoryDefinition = this.getRepository();
        if (this.repositoryDefinition != null) {
            this.selectedRepository = this.repositoryDefinition.getPluginKey();
            this.repositoryName = this.repositoryDefinition.getName();
            this.userDescription = this.repositoryDefinition.getDescription();
            this.vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.repositoryDefinition.getPluginKey());
            this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.SUCCESS);
            this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.SUCCESS);
        }
    }

    @Override
    public String doDefault() throws Exception {
        if (this.currentVcsTypeSelector != null) {
            boolean bl = this.overrideRepositoryLocation = this.repositoryId >= 0L && (this.repositoryDefinition.overridesLocation() || this.repositoryDefinition.overridesChangeDetectionOptions());
            if (this.defaultRepositoryTypeDifferent || this.parentRemoved) {
                this.overrideRepositoryLocation = true;
            }
            this.repositoryName = this.repositoryDefinition.getName();
            this.userDescription = this.repositoryDefinition.getDescription();
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "input";
    }

    private Set<VcsConfigurationHelper.Overrides> getOverrides() {
        HashSet<VcsConfigurationHelper.Overrides> overrides = new HashSet<VcsConfigurationHelper.Overrides>();
        overrides.add(VcsConfigurationHelper.Overrides.BRANCH);
        if (this.overrideRepositoryLocation) {
            overrides.add(VcsConfigurationHelper.Overrides.SERVER);
            overrides.add(VcsConfigurationHelper.Overrides.CHANGE_DETECTION);
        }
        return overrides;
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        if (this.repositoryDefinition != null) {
            JSONObject jsonRepositoryObject = new JSONObject();
            jsonRepositoryObject.put("id", this.repositoryDefinition.getId() > 0L ? this.repositoryDefinition.getId() : this.parentRepository.getId());
            jsonRepositoryObject.put("name", (Object)this.repositoryDefinition.getName());
            jsonRepositoryObject.put("description", (Object)this.repositoryDefinition.getDescription());
            jsonRepositoryObject.put("global", this.repositoryDefinition.isLinked());
            jsonRepositoryObject.put("isBranch", this.repositoryDefinition.getId() > 0L);
            jsonObject.put("repositoryResult", (Object)jsonRepositoryObject);
        }
        return jsonObject;
    }

    public String execute() {
        try {
            PartialVcsRepositoryData newRepositoryData = this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, this.userDescription, this.repositoryDefinition, this.getOverrides());
            if (this.repositoryDefinition.getId() > 0L) {
                if (!this.getOverrides().isEmpty()) {
                    this.repositoryDefinition = this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.repositoryId.longValue(), newRepositoryData);
                } else {
                    this.vcsRepositoryConfigurationService.deleteRepository(this.getMutablePlan(), this.repositoryId.longValue(), Long.valueOf(-1L));
                    this.repositoryDefinition = PartialVcsRepositoryDataImpl.createChild((VcsRepositoryData)this.parentRepository);
                }
            } else if (!this.getOverrides().isEmpty()) {
                this.repositoryDefinition = this.vcsRepositoryConfigurationService.createPlanRepository(this.getMutablePlan(), newRepositoryData);
            }
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
        return "success";
    }

    @Override
    @Nullable
    public PartialVcsRepositoryData getRepositoryById(long id) {
        return this.getRepository();
    }

    @Nullable
    public PartialVcsRepositoryData getRepository() {
        if (this.repositoryDefinition == null) {
            this.validatePlan();
            if (this.hasErrors()) {
                return null;
            }
            ImmutableChainBranch branch = (ImmutableChainBranch)Narrow.to((Object)this.getImmutablePlan(), ImmutableChainBranch.class);
            if (branch == null) {
                this.addActionError("Branch doesn't exist or is corrupt, can not perform repository editing operations.");
                return null;
            }
            ImmutableChain master = branch.getMaster();
            if (master == null) {
                this.addActionError("Branch doesn't exist or is corrupt, can not perform repository editing operations.");
                return null;
            }
            List repositoryDefinitionsForPlan = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)branch);
            for (PlanRepositoryLink repositoryLink : repositoryDefinitionsForPlan) {
                if (repositoryLink.getRepositoryDataEntity().getId() != this.repositoryId.longValue()) continue;
                this.repositoryDefinition = this.repositoryDefinitionManager.entityToUnmergedData(repositoryLink.getRepositoryDataEntity());
                this.parentRemoved = this.repositoryDefinition.getInheritedData().isMarkedForDeletion();
                this.parentRepository = this.findParentRepository(repositoryLink.getRepositoryDataEntity().getParent().getId());
            }
            if (this.repositoryDefinition == null) {
                List repositoryDefinitionsForMasterPlan = this.repositoryDefinitionManager.getPlanRepositoryLinks((ImmutablePlan)branch.getMaster());
                this.parentRepository = this.findParentRepository(this.repositoryId);
                if (this.parentRepository != null) {
                    this.repositoryDefinition = PartialVcsRepositoryDataImpl.createChild((VcsRepositoryData)this.parentRepository);
                }
            }
            if (this.parentRepository == null) {
                this.addActionError("You can not override specific source repository details for this branch because, no repository was found for the plan.");
                return null;
            }
            this.isDefaultRepository = this.parentRepository.getPosition() == 0;
            this.defaultRepositoryTypeDifferent = !this.parentRepository.getPluginKey().equals(this.repositoryDefinition.getPluginKey());
        }
        return this.repositoryDefinition;
    }

    private PlanRepositoryDefinition findParentRepository(long parentRepositoryId) {
        return this.repositoryDefinitionManager.getPlanRepositoryLinks(this.getImmutablePlan().getMaster()).stream().filter(prl -> prl.getRepositoryDataEntity().getId() == parentRepositoryId).findFirst().map(prl -> PlanRepositoryDefinitionImpl.createForPosition((VcsRepositoryData)this.repositoryDefinitionManager.entityToVcsData(prl.getRepositoryDataEntity()), (int)prl.getPosition())).orElse(null);
    }

    public void validate() {
        this.validatePlan();
        if (this.repositoryDefinition == null) {
            this.addActionError("You can not override specific source repository details for this branch because, no repository was found for the plan.");
            return;
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForPlan(this.getImmutablePlan()), () -> this.lambda$validate$2((ErrorCollection)errorCollection));
        this.addErrorCollection((ErrorCollection)errorCollection);
        if (this.hasErrors()) {
            this.currentVcsTypeSelector = this.prepareHtml(TaskRenderMode.ERROR);
            this.currentViewersSelectors = this.prepareViewersHtml(TaskRenderMode.ERROR);
        }
    }

    public boolean canOverrideBranch() {
        return !(this.vcsRepositoryModuleDescriptor instanceof LegacyRepositoryModuleDescriptor) && this.vcsRepositoryModuleDescriptor.getVcsBranchConfigurator() != null;
    }

    public boolean canOverrideCDOptions() {
        return this.vcsRepositoryModuleDescriptor.getVcsChangeDetectionOptionsConfigurator() != null;
    }

    private VcsUIConfigBean.VcsTypeSelector prepareHtml(@NotNull TaskRenderMode renderMode) {
        boolean canEdit = this.isRepositoryEditable();
        Long projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
        VcsUIConfigBean.VcsHtmlFragments fragments = canEdit ? this.vcsUIConfigBean.prepareEditHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, renderMode, projectId) : this.vcsUIConfigBean.prepareViewHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition.getCompleteData(), projectId);
        return new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition, this.vcsRepositoryModuleDescriptor, "", fragments, this.hasEntityPermission(BambooPermission.READ.getName(), this.repositoryDefinition));
    }

    public boolean isRepositoryEditable() {
        boolean canEdit = false;
        if (!this.isDefaultRepository) {
            return true;
        }
        ImmutableChainBranch branch = (ImmutableChainBranch)Narrow.to((Object)this.getImmutablePlan(), ImmutableChainBranch.class);
        if (branch != null) {
            canEdit = branch.getBuildDefinition().getBranchSpecificConfiguration().getPlanBranchWorkflow() != PlanBranchWorkflow.PULL_REQUEST_WORKFLOW;
        } else {
            log.info((Object)"Can't find branch, so repository details are not editable");
        }
        return canEdit;
    }

    private VcsUIConfigBean.VcsTypeSelector prepareParentHtml() {
        Long projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
        return new VcsUIConfigBean.VcsTypeSelector(this.repositoryDefinition.getInheritedData(), this.vcsRepositoryModuleDescriptor, "", this.vcsUIConfigBean.prepareViewHtmlFragments(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition.getInheritedData(), projectId), this.hasEntityPermission(BambooPermission.READ.getName(), this.repositoryDefinition.getInheritedData()));
    }

    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> prepareViewersHtml(@NotNull TaskRenderMode renderMode) {
        VcsRepositoryViewerDefinition viewerDefinition = this.repositoryDefinition.getCompleteData().getViewerConfiguration();
        this.setSelectedWebRepositoryViewer(viewerDefinition != null ? viewerDefinition.getPluginKey() : VcsViewerUIConfigBean.NO_VIEWER.getKey());
        return this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(this.vcsRepositoryModuleDescriptor.getCompleteKey(), viewerDefinition, renderMode);
    }

    private VcsViewerUIConfigBean.VcsViewerTypeSelector prepareParentViewerHtml() {
        return this.vcsViewerUIConfigBean.getViewerViewHtml(this.repositoryDefinition.getInheritedData().getViewerConfiguration());
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.currentViewersSelectors;
    }

    public VcsViewerUIConfigBean.VcsViewerTypeSelector getParentViewerSelector() {
        return this.prepareParentViewerHtml();
    }

    public boolean isOverrideRepositoryLocation() {
        return this.overrideRepositoryLocation;
    }

    public void setOverrideRepositoryLocation(boolean overrideRepositoryLocation) {
        this.overrideRepositoryLocation = overrideRepositoryLocation;
    }

    @Override
    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    @Override
    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public boolean isDefaultRepositoryTypeDifferent() {
        return this.defaultRepositoryTypeDifferent;
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeSelector() {
        return this.currentVcsTypeSelector;
    }

    public VcsUIConfigBean.VcsTypeSelector getParentVcsTypeSelector() {
        return this.prepareParentHtml();
    }

    public boolean isResetDone() {
        return this.resetDone;
    }

    public boolean isParentRemoved() {
        return this.parentRemoved;
    }

    public void setResetDone(boolean resetDone) {
        this.resetDone = resetDone;
    }

    private /* synthetic */ void lambda$validate$2(ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(this.vcsRepositoryModuleDescriptor, this.repositoryDefinition, errorCollection, this.getOverrides());
    }
}

