/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverterImpl;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class EditChainBranchNotifications
extends ChainActionSupport
implements BuildConfigurationAware,
PlanEditSecurityAware {
    private boolean saved;
    private BuildConfiguration buildConfiguration;
    private EventPublisher eventPublisher;

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public String input() {
        ImmutableChainBranch branch = (ImmutableChainBranch)Narrow.to((Object)this.getImmutableChain(), ImmutableChainBranch.class);
        if (branch == null) {
            this.addActionError("Can not edit Branch details no branch found");
            return "error";
        }
        return "input";
    }

    public String execute() throws Exception {
        ChainBranch branch = (ChainBranch)Narrow.to((Object)this.getMutableChain(), ChainBranch.class);
        if (branch == null) {
            this.addActionError("Can not edit Branch details no branch found");
            return "error";
        }
        BuildDefinition branchBuildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(branch.getPlanKey());
        BranchSpecificConfiguration bsc = (BranchSpecificConfiguration)BuildDefinitionConverterImpl.populate((HierarchicalConfiguration)this.buildConfiguration, (OptionallyConvertibleFromConfig)new BranchSpecificConfiguration());
        if (bsc != null) {
            branchBuildDefinition.setBranchSpecificConfiguration(bsc);
        }
        this.buildDefinitionManager.savePlanAndDefinition((Plan)branch, branchBuildDefinition);
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, branch.getPlanKey()));
        return "success";
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public List<BranchNotificationStrategy> getNotificationStrategies() {
        return ImmutableList.copyOf((Object[])BranchNotificationStrategy.values());
    }
}

