/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.configuration.external.SpecsConsumerFactory;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverterImpl;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.web.PlanConfigurationUIPluginHelper;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.branch.AbstractBranchTriggerConfigAction;
import com.atlassian.bamboo.ww2.actions.branch.BranchCreationType;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.RepositoryTriggerSelector;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.TriggerUIConfigBean;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class EditChainBranchDetails
extends AbstractBranchTriggerConfigAction
implements BuildConfigurationAware,
PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(EditChainBranchDetails.class);
    private static final String BRANCH_NAME = "branchName";
    private static final String BRANCH_DESCRIPTION = "branchDescription";
    private String branchName;
    private String branchDescription;
    private boolean enabled;
    private boolean saved;
    private boolean overrideBuildStrategy;
    private String planBranchCreation;
    private final Map<PlanIdentifier, String> branchesForAutoIntegration = new LinkedHashMap<PlanIdentifier, String>();
    private PlanValidationService planValidationService;
    private EventPublisher eventPublisher;
    private PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper;
    private PlanConfigHelper buildTriggerConditionConfigHelper;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private PlanBranchPullRequestService planBranchPullRequestService;
    @Autowired
    private VcsUIConfigBean vcsUIConfigBean;
    @Autowired
    private RssDetectionService rssDetectionService;
    @Autowired
    private SpecsConsumerFactory specsConsumerFactory;
    private boolean planBranchCleanUpEnabled;
    private boolean inactiveBranchCleanUpPlanLevelEnabled;
    private boolean removedBranchCleanUpPlanLevelEnabled;
    private int inactiveBranchCleanUpPeriod;
    private int removedBranchCleanUpPeriod;
    private boolean ignoreSpecs;
    private Set<Long> overridingRepositoryIds;

    private Set<Long> getOverridingRepositoryIds() {
        if (this.overridingRepositoryIds == null) {
            this.overridingRepositoryIds = this.repositoryDefinitionManager.getPlanRepositoryLinks(this.getImmutablePlan()).stream().map(prl -> prl.getRepositoryDataEntity().getId()).collect(Collectors.toSet());
        }
        return this.overridingRepositoryIds;
    }

    public boolean isRepositoryOverridden(PartialVcsRepositoryData partialVcsRepositoryData) {
        return this.getOverridingRepositoryIds().contains(partialVcsRepositoryData.getId()) && (partialVcsRepositoryData.overridesLocation() || partialVcsRepositoryData.overridesChangeDetectionOptions());
    }

    @Nullable
    public static String getRepositoryBranchName(PartialVcsRepositoryData partialVcsRepositoryData) {
        VcsBranchDefinition vcsBranchDefinition = partialVcsRepositoryData.getCompleteData().getBranch();
        return vcsBranchDefinition != null ? vcsBranchDefinition.getVcsBranch().getDisplayName() : null;
    }

    public String input() {
        ImmutableChainBranch branch = (ImmutableChainBranch)Narrow.to((Object)this.getImmutableChain(), ImmutableChainBranch.class);
        if (branch == null) {
            this.addActionError("Can not edit Branch details no branch found");
            return "error";
        }
        this.branchName = branch.getBuildName();
        this.branchDescription = branch.getDescription();
        this.enabled = !branch.isSuspendedFromBuilding();
        BranchSpecificConfiguration branchSpecificConfiguration = branch.getBuildDefinition().getBranchSpecificConfiguration();
        this.planBranchCleanUpEnabled = !branchSpecificConfiguration.isBranchCleanupDisabled();
        this.planBranchCreation = this.findBranchCreationType(branchSpecificConfiguration.getPlanBranchWorkflow()).getKey();
        this.ignoreSpecs = branchSpecificConfiguration.isIgnoreSpecs();
        BranchMonitoringConfiguration branchMonitoringConfiguration = branch.getBuildDefinition().getBranchMonitoringConfiguration();
        this.inactiveBranchCleanUpPlanLevelEnabled = branchMonitoringConfiguration.isInactiveBranchCleanUpEnabled();
        if (this.inactiveBranchCleanUpPlanLevelEnabled) {
            this.inactiveBranchCleanUpPeriod = branchMonitoringConfiguration.getInactiveBranchCleanUpPeriodInDays();
        }
        this.removedBranchCleanUpPlanLevelEnabled = branchMonitoringConfiguration.isRemovedBranchCleanUpEnabled();
        if (this.removedBranchCleanUpPlanLevelEnabled) {
            this.removedBranchCleanUpPeriod = branchMonitoringConfiguration.getRemovedBranchCleanUpPeriodInDays();
        }
        BuildDefinition branchBuildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(branch.getPlanKey());
        BuildDefinition fullBuildDefinition = this.buildDefinitionManager.getBuildDefinition(branch.getPlanKey());
        this.overrideBuildStrategy = branchBuildDefinition.getTriggerDefinitions() != null;
        TriggerDefinition triggerDefinition = (TriggerDefinition)Iterables.getFirst((Iterable)fullBuildDefinition.getTriggerDefinitions(), null);
        this.triggerModuleDescriptors = this.triggerTypeManager.getAvailableTriggerDescriptors((Triggerable)this.getImmutableChain());
        String strategyKey = triggerDefinition != null ? triggerDefinition.getPluginKey() : "manualOnly";
        this.buildConfiguration.addProperty("selectedBuildStrategy", (Object)strategyKey);
        this.triggerSelectors = new ArrayList();
        this.prepareTriggerEditHtmls(triggerDefinition);
        this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector("manualOnly", "Manual", "", ""));
        if (triggerDefinition != null) {
            TriggerConfigurationUtils.triggerConditionsToConfiguration((HierarchicalConfiguration)this.buildConfiguration, (TriggerDefinition)triggerDefinition);
        } else {
            this.buildTriggerConditionConfigHelper.addDefaultsToConfig(this.buildConfiguration);
        }
        return "input";
    }

    @NotNull
    private BranchCreationType findBranchCreationType(PlanBranchWorkflow planBranchWorkflow) {
        return Arrays.stream(BranchCreationType.values()).filter(creationType -> creationType.getCompatiblePlanBranchWorkflow() == planBranchWorkflow).findFirst().orElse(BranchCreationType.MANUAL);
    }

    public void validate() {
        boolean invalidIntegrationStrategy;
        this.planValidationService.validateName((ValidationAware)this, BRANCH_NAME, "chain", this.branchName);
        this.planValidationService.validateDescription((ValidationAware)this, BRANCH_DESCRIPTION, this.branchDescription);
        ImmutableChainBranch branch = (ImmutableChainBranch)Preconditions.checkNotNull((Object)Narrow.to((Object)this.getImmutableChain(), ImmutableChainBranch.class), (Object)(this.getImmutableChain().getPlanKey() + " is not a branch"));
        boolean isPlanNameConflicting = this.chainBranchManager.isPlanBranchNameConflicting(branch.getMaster(), this.getImmutableChain().getId(), this.branchName);
        if (isPlanNameConflicting) {
            this.addFieldError(BRANCH_NAME, this.getText("branch.name.exists"));
        }
        BranchCreationType workflow = BranchCreationType.byKey(this.planBranchCreation);
        BranchIntegrationConfiguration integrationConfiguration = (BranchIntegrationConfiguration)BuildDefinitionConverterImpl.populate((HierarchicalConfiguration)this.buildConfiguration, (OptionallyConvertibleFromConfig)new BranchIntegrationConfigurationImpl());
        boolean bl = invalidIntegrationStrategy = integrationConfiguration != null && integrationConfiguration.isEnabled() && integrationConfiguration.getStrategy() != null && !workflow.getCompatiblePlanBranchWorkflow().getIntegrationStrategies().contains(integrationConfiguration.getStrategy());
        if (invalidIntegrationStrategy) {
            this.addActionError(this.getText("branch.integration.error.unsupported.for.workflow"));
        }
        if (this.overrideBuildStrategy) {
            this.validateTriggerConfiguration();
            this.buildTriggerConditionConfigHelper.prepareConfig(this.buildConfiguration);
            this.buildTriggerConditionConfigHelper.validateConfig((com.opensymphony.xwork.ValidationAware)this, this.buildConfiguration);
        }
        if (this.hasErrors()) {
            this.renderTriggerEditHtmlsWithErrors();
            this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector("manualOnly", "Manual", "Build only when triggered manually", ""));
        }
    }

    public String execute() throws Exception {
        ChainBranch branch = (ChainBranch)Narrow.to((Object)this.getMutableChain(), ChainBranch.class);
        if (branch == null) {
            this.addActionError("Can not edit Branch details no branch found");
            return "error";
        }
        branch.setBuildName(this.branchName);
        branch.setDescription(this.branchDescription);
        BuildDefinition branchBuildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(branch.getPlanKey());
        boolean wasIgnoringSpecs = branchBuildDefinition.getBranchSpecificConfiguration().isIgnoreSpecs();
        BranchIntegrationConfigurationImpl branchIntegrationConfiguration = (BranchIntegrationConfigurationImpl)BuildDefinitionConverterImpl.populate((HierarchicalConfiguration)this.buildConfiguration, (OptionallyConvertibleFromConfig)new BranchIntegrationConfigurationImpl());
        if (branchBuildDefinition.getBranchSpecificConfiguration().getPlanBranchWorkflow() == PlanBranchWorkflow.PULL_REQUEST_WORKFLOW) {
            this.planBranchPullRequestService.findForChainBranch(branch.getPlanKey()).ifPresent(pr -> branchIntegrationConfiguration.setBranchIntegrationPoint((BranchIntegrationPoint)BranchIntegrationPointImpl.forVcsReference((String)pr.getVcsPullRequest().getTarget())));
        }
        branchBuildDefinition.setBranchIntegrationConfiguration((BranchIntegrationConfiguration)branchIntegrationConfiguration);
        if (this.overrideBuildStrategy) {
            TriggerModuleDescriptor triggerModuleDescriptor;
            ArrayList<TriggerDefinition> triggerDefinitions = new ArrayList<TriggerDefinition>();
            String selectedStrategy = this.buildConfiguration.getString("selectedBuildStrategy", "manualOnly");
            if (!selectedStrategy.equals("manualOnly") && (triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(selectedStrategy)) != null) {
                triggerDefinitions.add(new TriggerDefinitionImpl.Builder().fromDescriptor(triggerModuleDescriptor).id(1L).triggeringRepositories(this.triggeringRepositoriesFromInput(triggerModuleDescriptor)).configuration(this.triggerUIConfigBean.getTriggerConfigurationMap(triggerModuleDescriptor, null)).triggerConditionsConfiguration(this.triggerConditionsConfigurationFromInput()).build());
            }
            branchBuildDefinition.setTriggerDefinitions(triggerDefinitions);
        } else {
            branchBuildDefinition.setTriggerDefinitions(null);
        }
        this.buildTriggerConditionConfigHelper.cleanConfig(this.getBuildConfiguration());
        BranchSpecificConfiguration bsc = (BranchSpecificConfiguration)BuildDefinitionConverterImpl.populate((HierarchicalConfiguration)this.buildConfiguration, (OptionallyConvertibleFromConfig)new BranchSpecificConfiguration());
        bsc.setBranchCleanupDisabled(!this.isPlanBranchCleanUpEnabled());
        bsc.setIgnoreSpecs(this.ignoreSpecs);
        branchBuildDefinition.setBranchSpecificConfiguration(bsc);
        branch.setSuspendedFromBuilding(!this.enabled);
        this.buildDefinitionManager.savePlanAndDefinition((Plan)branch, branchBuildDefinition);
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, branch.getPlanKey()));
        if (wasIgnoringSpecs && !this.ignoreSpecs) {
            log.info((Object)("Scheduling specs detection for plan branch " + branch.getPlanKey()));
            PlanRepositoryDefinition repository = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)branch);
            if (repository != null) {
                try {
                    this.rssDetectionService.enqueue(repository.getRootVcsRepositoryId(), repository.getBranch().getVcsBranch(), true, this.specsConsumerFactory.createDivergentBranchSpecsUpdateConsumer(repository.getBranch().getVcsBranch(), (Multimap)ImmutableMultimap.of((Object)branch.getMaster(), (Object)branch.getPlanKey())));
                }
                catch (Exception e) {
                    log.info((Object)("Exception caught while trying to enqueue RSS detection for repository: " + repository.getId()), (Throwable)e);
                }
            }
        }
        return "success";
    }

    private VcsRepositoryModuleDescriptor getModuleDescriptorOfDefaultRepository() {
        PlanRepositoryDefinition defaultRepository = this.getDefaultRepositoryDefinition();
        if (defaultRepository != null) {
            return this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepository.getPluginKey());
        }
        return null;
    }

    public boolean isBranchDetectionCapable() {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptorOfDefaultRepository();
        return moduleDescriptor != null && moduleDescriptor.supportsBranchDetection();
    }

    public boolean isMergeCapable() {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptorOfDefaultRepository();
        return moduleDescriptor != null && moduleDescriptor.supportsMerging();
    }

    public String getBranchIntegrationEditHtml() {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptorOfDefaultRepository();
        if (moduleDescriptor != null) {
            return this.vcsUIConfigBean.renderBranchIntegrationHtml(moduleDescriptor, (VcsRepositoryData)this.getDefaultRepositoryDefinition());
        }
        return null;
    }

    public String getDefaultRepositoryType() {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptorOfDefaultRepository();
        if (moduleDescriptor != null) {
            return moduleDescriptor.getName();
        }
        return "Unknown";
    }

    public List<RepositoryTriggerSelector> getRepositoryTriggerSelectors() {
        return this.getRepositoryTriggerSelectors((TriggerDefinition)Iterables.getFirst((Iterable)this.buildDefinitionManager.getBuildDefinition(this.getImmutableChain().getPlanKey()).getTriggerDefinitions(), null));
    }

    public PlanRepositoryDefinition getDefaultRepositoryDefinition() {
        return PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)this.getImmutableChain());
    }

    public String getPlanBranchCreation() {
        return this.planBranchCreation;
    }

    public void setPlanBranchCreation(String planBranchCreation) {
        this.planBranchCreation = planBranchCreation;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchDescription() {
        return this.branchDescription;
    }

    public void setBranchDescription(String branchDescription) {
        this.branchDescription = branchDescription;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPlanValidationService(PlanValidationService planValidationService) {
        this.planValidationService = planValidationService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Map<PlanIdentifier, String> getBranchesForAutoIntegration() {
        if (this.branchesForAutoIntegration.isEmpty()) {
            LinkedHashMap<PlanIdentifier, String> branches = new LinkedHashMap<PlanIdentifier, String>();
            for (PlanIdentifier planIdentifier : this.getSiblingBranchIdentifiers()) {
                if (planIdentifier.getPlanType() == PlanType.CHAIN) {
                    this.branchesForAutoIntegration.put(planIdentifier, this.getText("branch.master.title"));
                    continue;
                }
                branches.put(planIdentifier, this.getText("branch.title"));
            }
            this.branchesForAutoIntegration.putAll(branches);
        }
        return this.branchesForAutoIntegration;
    }

    @NotNull
    public String getTriggerConditionEditHtml() {
        return this.planConfigurationUIPluginHelper.getEditHtml(this.getBuildConfiguration(), this.getMutablePlan(), BuildTriggerCondition.class);
    }

    @NotNull
    public List<PlanRepositoryDefinition> getRepositoryDefinitions() {
        return this.getImmutableChain().getPlanRepositoryDefinitions();
    }

    @NotNull
    public List<PartialVcsRepositoryData> getPartialVcsRepositoryData() {
        return this.getImmutableChain().getPlanRepositoryDefinitions().stream().map(BambooIdProvider::getId).map(arg_0 -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getVcsRepositoryDataForEditing(arg_0)).collect(Collectors.toList());
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public void setPlanConfigurationUIPluginHelper(PlanConfigurationUIPluginHelper planConfigurationUIPluginHelper) {
        this.planConfigurationUIPluginHelper = planConfigurationUIPluginHelper;
    }

    public boolean isOverrideBuildStrategy() {
        return this.overrideBuildStrategy;
    }

    public void setOverrideBuildStrategy(boolean overrideBuildStrategy) {
        this.overrideBuildStrategy = overrideBuildStrategy;
    }

    public void setBuildTriggerConditionConfigHelper(PlanConfigHelper buildTriggerConditionConfigHelper) {
        this.buildTriggerConditionConfigHelper = buildTriggerConditionConfigHelper;
    }

    public boolean isPlanBranchCleanUpEnabled() {
        return this.planBranchCleanUpEnabled;
    }

    public void setPlanBranchCleanUpEnabled(boolean planBranchCleanUpEnabled) {
        this.planBranchCleanUpEnabled = planBranchCleanUpEnabled;
    }

    public boolean isIgnoreSpecs() {
        return this.ignoreSpecs;
    }

    public void setIgnoreSpecs(boolean ignoreSpecs) {
        this.ignoreSpecs = ignoreSpecs;
    }

    public boolean isInactiveBranchCleanUpPlanLevelEnabled() {
        return this.inactiveBranchCleanUpPlanLevelEnabled;
    }

    public void setInactiveBranchCleanUpPlanLevelEnabled(boolean inactiveBranchCleanUpPlanLevelEnabled) {
        this.inactiveBranchCleanUpPlanLevelEnabled = inactiveBranchCleanUpPlanLevelEnabled;
    }

    public boolean isRemovedBranchCleanUpPlanLevelEnabled() {
        return this.removedBranchCleanUpPlanLevelEnabled;
    }

    public void setRemovedBranchCleanUpPlanLevelEnabled(boolean removedBranchCleanUpPlanLevelEnabled) {
        this.removedBranchCleanUpPlanLevelEnabled = removedBranchCleanUpPlanLevelEnabled;
    }

    public int getInactiveBranchCleanUpPeriod() {
        return this.inactiveBranchCleanUpPeriod;
    }

    public void setInactiveBranchCleanUpPeriod(int inactiveBranchCleanUpPeriod) {
        this.inactiveBranchCleanUpPeriod = inactiveBranchCleanUpPeriod;
    }

    public int getRemovedBranchCleanUpPeriod() {
        return this.removedBranchCleanUpPeriod;
    }

    public void setRemovedBranchCleanUpPeriod(int removedBranchCleanUpPeriod) {
        this.removedBranchCleanUpPeriod = removedBranchCleanUpPeriod;
    }
}

