/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.ChainBranchCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.event.analytics.ChainBranchCreatedAnalyticsEvent;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.branch.BranchCreationFacade;
import com.atlassian.bamboo.plan.branch.ChainBranchCreationResult;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.xwork2.ActionContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateChainBranch
extends ChainActionSupport
implements PlanAdminSecurityAware,
BuildConfigurationAware {
    private static final Logger log = Logger.getLogger(CreateChainBranch.class);
    private static String MANUAL = "MANUAL";
    private static String AUTO = "AUTO";
    private BuildConfiguration buildConfiguration;
    private String creationOption = AUTO;
    private String branchesForCreation;
    private String redirectAddress;
    private String branchVcsName;
    private String branchName;
    private String branchDescription;
    @Autowired
    private ChainBranchCreationService chainBranchCreationService;
    @Autowired
    private BranchCreationFacade branchCreationFacade;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;

    public String execute() throws Exception {
        ImmutableChain chain = this.getImmutableChain();
        if (chain == null) {
            this.addActionError(this.getText("branch.create.error.plan.required"));
            return "error";
        }
        ActionParametersMapImpl parametersMap = new ActionParametersMapImpl(ActionContext.getContext());
        if (MANUAL.equals(this.creationOption)) {
            ChainBranchCreationResult branchCreationResult;
            PlanCreationService.EnablePlan enablePlan = parametersMap.getBoolean("tmp.createAsEnabled") ? PlanCreationService.EnablePlan.ENABLED : PlanCreationService.EnablePlan.DISABLED;
            VcsBranch newVcsBranch = null;
            if (StringUtils.isNotEmpty((CharSequence)this.branchVcsName)) {
                newVcsBranch = this.createVcsBranchFromName(this.branchVcsName);
                if (this.hasAnyErrors()) {
                    return "error";
                }
            }
            try {
                branchCreationResult = this.branchCreationFacade.createChainBranch(chain, PlanBranchWorkflow.MANUAL_WORKFLOW, this.branchName, this.branchDescription, newVcsBranch, enablePlan, false, (ValidationAware)this);
                if (this.hasAnyErrors()) {
                    return "error";
                }
            }
            catch (PlanCreationDeniedException e) {
                this.addActionError((Exception)((Object)e));
                return "error";
            }
            String planKey = branchCreationResult.getPlanKey().getKey();
            this.setPlanKey(planKey);
            this.redirectAddress = "/branch/admin/config/editChainBranchDetails.action?planKey=" + planKey;
        } else {
            PlanCreationService.EnablePlan enablePlan = parametersMap.getBoolean("tmp.auto.createAsEnabled") ? PlanCreationService.EnablePlan.ENABLED : PlanCreationService.EnablePlan.DISABLED;
            PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
            VcsBranchConfigurator vcsBranchConfigurator = moduleDescriptor.getVcsBranchConfigurator();
            List createdPlanBranches = this.branchCreationFacade.createManualBranches(chain, (Collection)this.getBranchesForCreation().stream().filter(Objects::nonNull).map(arg_0 -> ((VcsBranchConfigurator)vcsBranchConfigurator).createVcsBranchFromName(arg_0)).collect(Collectors.toList()), (ErrorCollection)this, enablePlan);
            if (this.hasAnyErrors()) {
                return "error";
            }
            if (createdPlanBranches.size() == 1) {
                this.redirectAddress = "/branch/admin/config/editChainBranchDetails.action?planKey=" + ((ChainBranchCreationResult)createdPlanBranches.get(0)).getPlanKey().getKey();
            } else {
                this.redirectAddress = "/chain/admin/config/configureBranches.action?buildKey=" + chain.getPlanKey();
                this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.plan.branch.created.multiple"));
            }
        }
        this.eventPublisher.publish((Object)ChainBranchCreatedAnalyticsEvent.byManualRequest());
        this.getJsonObject().put("redirectUrl", (Object)this.redirectAddress);
        return "success";
    }

    private List<String> getBranchesForCreation() {
        return Arrays.asList(this.branchesForCreation.split("~"));
    }

    public void validate() {
        if (MANUAL.equals(this.creationOption)) {
            ActionParametersMapImpl parametersMap = new ActionParametersMapImpl(ActionContext.getContext());
            this.chainBranchCreationService.validatePlan((ValidationAware)this, new BuildConfiguration(), (ActionParametersMap)parametersMap);
        } else if (StringUtils.isEmpty((CharSequence)this.branchesForCreation)) {
            this.addFieldError("branchesForCreation", this.getText("branch.create.auto.error.required"));
        }
    }

    public boolean isBranchDetectionCapable() {
        PlanRepositoryDefinition planRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)this.getImmutablePlan());
        if (planRepositoryDefinition != null) {
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey());
            return moduleDescriptor != null && moduleDescriptor.supportsBranchDetection();
        }
        return false;
    }

    public boolean isBranchConfigurable() {
        PlanRepositoryDefinition planRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)this.getImmutablePlan());
        if (planRepositoryDefinition != null) {
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey());
            return moduleDescriptor != null && moduleDescriptor.getVcsBranchConfigurator() != null;
        }
        return false;
    }

    @Nullable
    private VcsBranch createVcsBranchFromName(String vcsBranchName) {
        ImmutableChain chain = this.getImmutableChain();
        if (chain == null) {
            this.addActionError(this.getText("branch.create.error.plan.required"));
            return null;
        }
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            this.addFieldError("branchVcsName", this.getText("branch.create.error.no.default.repository", Collections.singletonList(chain.getName())));
            return null;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null) {
            this.addActionError(this.getText("branch.create.error.plugin.disabled", Collections.singletonList(defaultRepositoryDefinition.getPluginKey())));
            return null;
        }
        VcsBranchConfigurator vcsBranchConfigurator = moduleDescriptor.getVcsBranchConfigurator();
        if (vcsBranchConfigurator == null) {
            this.addFieldError("branchVcsName", this.getText("branch.create.error.repository.not.support.branches", Collections.singletonList(chain.getName())));
            return null;
        }
        return vcsBranchConfigurator.createVcsBranchFromName(vcsBranchName);
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        if (this.buildConfiguration == null) {
            this.buildConfiguration = new BuildConfiguration();
        }
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public String getCreationOption() {
        return this.creationOption;
    }

    public void setCreationOption(String creationOption) {
        this.creationOption = creationOption;
    }

    public String getBranchVcsName() {
        return this.branchVcsName;
    }

    public void setBranchVcsName(String branchVcsName) {
        this.branchVcsName = branchVcsName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchDescription() {
        return this.branchDescription;
    }

    public void setBranchDescription(String branchDescription) {
        this.branchDescription = branchDescription;
    }

    public void setBranchesForCreation(String branchesForCreation) {
        this.branchesForCreation = branchesForCreation;
    }

    public String getRedirectAddress() {
        return this.redirectAddress;
    }
}

