/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.ChainBranchConfigUpdatedEvent;
import com.atlassian.bamboo.event.analytics.PlanConfigurationChangedAnalyticsEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverterImpl;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.branch.BranchCreationFacade;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchTriggeringOption;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.branch.AbstractBranchTriggerConfigAction;
import com.atlassian.bamboo.ww2.actions.branch.BranchCreationType;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.RepositoryTriggerSelector;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureBranches
extends AbstractBranchTriggerConfigAction
implements BuildConfigurationAware,
PlanEditSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureBranches.class);
    protected static final String BRANCH_NAME_PATTERN_FIELD = "planBranchCreationRegularExpression";
    protected static final String PLAN_BRANCH_CLEAN_UP_PERIOD_IN_DAYS = "removedBranchCleanUpPeriodInDays";
    protected static final String PLAN_BRANCH_INACTIVITY_CLEAN_UP_PERIOD_IN_DAYS = "inactiveBranchCleanUpPeriodInDays";
    private String planBranchCreation = BranchCreationType.MANUAL.getKey();
    private String planBranchCreationRegularExpression = ".*";
    private boolean deletePlanBranchWhenBranchRemovedFromVcs = false;
    private String removedBranchCleanUpPeriodInDays = String.valueOf(7);
    private boolean deletePlanBranchWhenBranchIsInactiveInVcs = false;
    private String inactiveBranchCleanUpPeriodInDays = String.valueOf(30);
    private boolean saved;
    private boolean remoteJiraBranchLinkingEnabled;
    private String branchTriggering = BranchTriggeringOption.INHERITED.getKey();
    private Map<PlanIdentifier, String> branchesForAutoIntegration = new LinkedHashMap<PlanIdentifier, String>();
    private String defaultNotificationStrategy;
    private VcsRepositoryModuleDescriptor defaultRepositoryModuleDescriptor;
    private PartialVcsRepositoryData defaultRepositoryData;
    private VcsUIConfigBean.VcsHtmlFragments repositoryEditHtml;
    protected TriggerModuleDescriptor triggerDescriptor;
    @Autowired
    private BranchCreationFacade branchCreationFacade;
    @Autowired
    private ScopedExclusionService scopedExclusionService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    private VcsUIConfigBean vcsUIConfigBean;
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;

    public void validate() {
        try {
            if ("".equals(this.planBranchCreationRegularExpression)) {
                this.addFieldError(BRANCH_NAME_PATTERN_FIELD, "This field cannot be empty.");
            }
            Pattern.compile(this.planBranchCreationRegularExpression);
        }
        catch (PatternSyntaxException e) {
            this.addFieldError(BRANCH_NAME_PATTERN_FIELD, "Invalid expression. Please specify a valid one. " + e.toString());
        }
        if (this.deletePlanBranchWhenBranchRemovedFromVcs && NumberUtils.toInt((String)this.removedBranchCleanUpPeriodInDays, (int)-1) < 0) {
            this.addFieldError(PLAN_BRANCH_CLEAN_UP_PERIOD_IN_DAYS, this.getText("chain.config.branches.deletion.error.wrong.range", Collections.singletonList(0)));
        }
        if (this.deletePlanBranchWhenBranchIsInactiveInVcs && NumberUtils.toInt((String)this.inactiveBranchCleanUpPeriodInDays, (int)-1) < 1) {
            this.addFieldError(PLAN_BRANCH_INACTIVITY_CLEAN_UP_PERIOD_IN_DAYS, this.getText("chain.config.branches.deletion.error.wrong.range", Collections.singletonList(1)));
        }
        this.initDefaultRepository();
        if (this.defaultRepositoryData != null && this.defaultRepositoryModuleDescriptor != null && this.defaultRepositoryModuleDescriptor.getVcsBranchDetectionOptionsConfigurator() != null) {
            ActionParametersMapImpl apm = new ActionParametersMapImpl(ActionContext.getContext(), true);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.defaultRepositoryModuleDescriptor.getVcsBranchDetectionOptionsConfigurator().validate((ActionParametersMap)apm, (ErrorCollection)errorCollection);
            this.addErrorCollection((ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                Long projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
                this.repositoryEditHtml = this.vcsUIConfigBean.prepareEditHtmlFragments(this.defaultRepositoryModuleDescriptor, this.defaultRepositoryData, TaskRenderMode.ERROR, projectId);
            }
        }
        if (this.branchTriggering.equals(BranchTriggeringOption.CUSTOM.getKey())) {
            this.validateTriggerConfiguration();
        }
        if (this.hasErrors()) {
            this.renderTriggerEditHtmlsWithErrors();
        }
    }

    public String input() throws Exception {
        this.initDefaultRepository();
        if (this.defaultRepositoryData != null && this.defaultRepositoryModuleDescriptor != null && this.defaultRepositoryModuleDescriptor.getVcsBranchDetectionOptionsConfigurator() != null) {
            Long projectId = this.getProject() != null ? Long.valueOf(this.getProject().getId()) : null;
            this.repositoryEditHtml = this.vcsUIConfigBean.prepareEditHtmlFragments(this.defaultRepositoryModuleDescriptor, this.defaultRepositoryData, TaskRenderMode.SUCCESS, projectId);
        }
        BranchMonitoringConfiguration monitoringConfiguration = this.getImmutablePlan().getBuildDefinition().getBranchMonitoringConfiguration();
        this.populateBranchCreationSettings(monitoringConfiguration);
        this.populateRemovedBranchCleanUpSettings(monitoringConfiguration);
        this.populateInactiveBranchCleanUpSettings(monitoringConfiguration);
        this.defaultNotificationStrategy = monitoringConfiguration.getDefaultBranchNotificationStrategy().getKey();
        this.remoteJiraBranchLinkingEnabled = monitoringConfiguration.isRemoteJiraBranchLinkingEnabled();
        this.branchTriggering = monitoringConfiguration.getBranchTriggeringOption().getKey();
        this.triggerModuleDescriptors = this.triggerTypeManager.getAvailableTriggerDescriptors((Triggerable)this.getImmutableChain());
        this.triggerSelectors = new ArrayList();
        TriggerDefinition triggerDefinition = monitoringConfiguration.getDefaultTrigger();
        if (triggerDefinition != null) {
            this.triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(triggerDefinition.getPluginKey());
            this.buildConfiguration.addProperty("selectedBuildStrategy", (Object)triggerDefinition.getPluginKey());
        }
        this.prepareTriggerEditHtmls(triggerDefinition);
        return "input";
    }

    private void initDefaultRepository() {
        PlanRepositoryDefinition planRepositoryDefinition;
        ImmutablePlan immutablePlan = this.getImmutablePlan();
        if (immutablePlan != null && (planRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)immutablePlan)) != null) {
            this.defaultRepositoryData = this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(planRepositoryDefinition.getId());
            this.defaultRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.defaultRepositoryData.getPluginKey());
        }
    }

    @RssConfigurationAware
    public String update() {
        Plan plan = this.getMutablePlan();
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition(plan.getPlanKey());
        BranchMonitoringConfiguration monitoringConfiguration = buildDefinition.getBranchMonitoringConfiguration();
        PlanBranchWorkflow previousPlanBranchWorkflow = monitoringConfiguration.getPlanBranchWorkflow();
        this.updateBranchMonitoringConfiguration(monitoringConfiguration);
        if (this.defaultRepositoryData != null && this.defaultRepositoryModuleDescriptor != null && this.defaultRepositoryModuleDescriptor.getVcsBranchDetectionOptionsConfigurator() != null) {
            PartialVcsRepositoryData newRepositoryData = this.vcsUIConfigBean.overrideBranchDetectionOptionsWithActionData(this.defaultRepositoryModuleDescriptor, this.defaultRepositoryData);
            this.vcsRepositoryConfigurationService.editRepository(this.getMutablePlan(), this.defaultRepositoryData.getId(), newRepositoryData);
        }
        this.schedulePlanBranchInitialization(plan, buildDefinition, previousPlanBranchWorkflow);
        this.triggerAnalyticsEvent(plan.getPlanKey(), buildDefinition);
        return "success";
    }

    private void triggerAnalyticsEvent(@NotNull PlanKey planKey, @NotNull BuildDefinition buildDefinition) {
        BranchMonitoringConfiguration monitoringConfiguration = buildDefinition.getBranchMonitoringConfiguration();
        this.eventPublisher.publish((Object)new ChainBranchConfigUpdatedEvent((Object)this, planKey, monitoringConfiguration));
        this.eventPublisher.publish((Object)new PlanConfigurationChangedAnalyticsEvent());
    }

    protected void schedulePlanBranchInitialization(Plan plan, BuildDefinition buildDefinition, PlanBranchWorkflow previousPlanBranchWorkflow) {
        boolean needToInitializeBranches = PlanBranchWorkflow.BRANCH_WORKFLOW != previousPlanBranchWorkflow && PlanBranchWorkflow.BRANCH_WORKFLOW == buildDefinition.getBranchMonitoringConfiguration().getPlanBranchWorkflow() && plan instanceof ImmutableChain;
        this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)plan.getPlanKey(), ScopedExclusionServiceHelper.adapt((Runnable)this.savePlanAndScheduleBranchInitialisation(plan, buildDefinition, needToInitializeBranches)));
    }

    protected void updateBranchMonitoringConfiguration(BranchMonitoringConfiguration branchMonitoringConfiguration) {
        if (this.isBranchDetectionCapable() || this.isPullRequestAware()) {
            branchMonitoringConfiguration.setPlanBranchWorkflow(BranchCreationType.byKey(this.planBranchCreation).getCompatiblePlanBranchWorkflow());
            this.updateBranchCreationSettings(branchMonitoringConfiguration);
            this.updateRemovedBranchCleanUpSettings(branchMonitoringConfiguration);
            this.updateInactiveBranchCleanUpSettings(branchMonitoringConfiguration);
        }
        branchMonitoringConfiguration.setDefaultBranchNotificationStrategy(BranchNotificationStrategy.fromKey((String)this.defaultNotificationStrategy));
        branchMonitoringConfiguration.setRemoteJiraBranchLinkingEnabled(this.remoteJiraBranchLinkingEnabled);
        branchMonitoringConfiguration.setBranchTriggeringOption(BranchTriggeringOption.fromKey((String)this.branchTriggering));
        BranchIntegrationConfigurationImpl bic = (BranchIntegrationConfigurationImpl)BuildDefinitionConverterImpl.populate((HierarchicalConfiguration)this.buildConfiguration, (OptionallyConvertibleFromConfig)new BranchIntegrationConfigurationImpl(true));
        branchMonitoringConfiguration.setDefaultBranchIntegrationConfiguration((BranchIntegrationConfiguration)bic);
        if (branchMonitoringConfiguration.getBranchTriggeringOption() == BranchTriggeringOption.CUSTOM) {
            String selectedStrategy = this.buildConfiguration.getString("selectedBuildStrategy", "manualOnly");
            this.triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(selectedStrategy);
            TriggerDefinition newTriggerDefinition = new TriggerDefinitionImpl.Builder().fromDescriptor(this.triggerDescriptor).id(1L).userDescription("Branch trigger").triggeringRepositories(this.triggeringRepositoriesFromInput(this.triggerDescriptor)).configuration(this.triggerUIConfigBean.getTriggerConfigurationMap(this.triggerDescriptor, null)).enabled(true).build();
            branchMonitoringConfiguration.setDefaultTrigger(newTriggerDefinition);
        } else {
            branchMonitoringConfiguration.setDefaultTrigger(null);
        }
    }

    private void updateInactiveBranchCleanUpSettings(BranchMonitoringConfiguration branchMonitoringConfiguration) {
        branchMonitoringConfiguration.setInactiveBranchCleanUpEnabled(this.deletePlanBranchWhenBranchIsInactiveInVcs);
        if (this.deletePlanBranchWhenBranchIsInactiveInVcs) {
            branchMonitoringConfiguration.setInactiveBranchCleanUpPeriodInDays(Integer.parseInt(this.inactiveBranchCleanUpPeriodInDays));
        }
    }

    private void updateRemovedBranchCleanUpSettings(BranchMonitoringConfiguration branchMonitoringConfiguration) {
        branchMonitoringConfiguration.setRemovedBranchCleanUpEnabled(this.deletePlanBranchWhenBranchRemovedFromVcs);
        if (this.deletePlanBranchWhenBranchRemovedFromVcs) {
            branchMonitoringConfiguration.setRemovedBranchCleanUpPeriodInDays(Integer.parseInt(this.removedBranchCleanUpPeriodInDays));
        } else {
            branchMonitoringConfiguration.setRemovedBranchCleanUpPeriodInDays(0);
        }
    }

    private void updateBranchCreationSettings(@NotNull BranchMonitoringConfiguration branchMonitoringConfiguration) {
        if (BranchCreationType.NEW_MATCHING_VCS_BRANCH.getKey().equals(this.planBranchCreation)) {
            branchMonitoringConfiguration.setMatchingPattern(this.planBranchCreationRegularExpression);
        } else {
            branchMonitoringConfiguration.setMatchingPattern("");
        }
    }

    private Runnable savePlanAndScheduleBranchInitialisation(Plan plan, BuildDefinition buildDefinition, boolean needToInitializeBranches) {
        return () -> {
            this.buildDefinitionManager.savePlanAndDefinition(plan, buildDefinition);
            if (needToInitializeBranches) {
                this.branchCreationFacade.scheduleBranchListInitialisation((Chain)plan);
            }
            this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, plan.getPlanKey()));
        };
    }

    private void populateBranchCreationSettings(BranchMonitoringConfiguration monitoringConfiguration) {
        switch (monitoringConfiguration.getPlanBranchWorkflow()) {
            case BRANCH_WORKFLOW: {
                if (StringUtils.isEmpty((CharSequence)monitoringConfiguration.getMatchingPattern())) {
                    this.planBranchCreation = BranchCreationType.NEW_VCS_BRANCH.getKey();
                    break;
                }
                this.planBranchCreation = BranchCreationType.NEW_MATCHING_VCS_BRANCH.getKey();
                this.planBranchCreationRegularExpression = monitoringConfiguration.getMatchingPattern();
                break;
            }
            case MANUAL_WORKFLOW: {
                this.planBranchCreation = BranchCreationType.MANUAL.getKey();
                break;
            }
            case PULL_REQUEST_WORKFLOW: {
                this.planBranchCreation = BranchCreationType.PR.getKey();
            }
        }
        if (this.getBranchCreationTypes().stream().noneMatch(item -> item.getKey().equals(this.planBranchCreation))) {
            this.planBranchCreation = BranchCreationType.MANUAL.getKey();
        }
    }

    private void populateRemovedBranchCleanUpSettings(BranchMonitoringConfiguration monitoringConfiguration) {
        this.deletePlanBranchWhenBranchRemovedFromVcs = monitoringConfiguration.isRemovedBranchCleanUpEnabled();
        if (this.deletePlanBranchWhenBranchRemovedFromVcs) {
            this.removedBranchCleanUpPeriodInDays = String.valueOf(monitoringConfiguration.getRemovedBranchCleanUpPeriodInDays());
        }
    }

    private void populateInactiveBranchCleanUpSettings(BranchMonitoringConfiguration monitoringConfiguration) {
        this.deletePlanBranchWhenBranchIsInactiveInVcs = monitoringConfiguration.isInactiveBranchCleanUpEnabled();
        if (this.deletePlanBranchWhenBranchIsInactiveInVcs) {
            this.inactiveBranchCleanUpPeriodInDays = String.valueOf(monitoringConfiguration.getInactiveBranchCleanUpPeriodInDays());
        }
    }

    public Map<PlanIdentifier, String> getBranchesForAutoIntegration() {
        if (this.branchesForAutoIntegration.isEmpty()) {
            LinkedHashMap<PlanIdentifier, String> branches = new LinkedHashMap<PlanIdentifier, String>();
            for (PlanIdentifier planIdentifier : this.getSiblingBranchIdentifiers()) {
                if (planIdentifier.getPlanType() == PlanType.CHAIN) {
                    this.branchesForAutoIntegration.put(planIdentifier, this.getText("branch.master.title"));
                    continue;
                }
                branches.put(planIdentifier, this.getText("branch.title"));
            }
            this.branchesForAutoIntegration.putAll(branches);
        }
        return this.branchesForAutoIntegration;
    }

    public boolean isHideBranchesSplashScreen() {
        PropertySet properties = this.bambooUserManager.getPropertySet(this.getUser());
        if (properties != null) {
            return Boolean.parseBoolean(properties.getString("bamboo.user.branches.splashscreen.hide"));
        }
        return true;
    }

    public String getBranchIntegrationEditHtml() {
        if (this.defaultRepositoryModuleDescriptor != null) {
            return this.vcsUIConfigBean.renderBranchIntegrationHtml(this.defaultRepositoryModuleDescriptor, this.defaultRepositoryData.getCompleteData());
        }
        return null;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public String getPlanBranchCreation() {
        return this.planBranchCreation;
    }

    public void setPlanBranchCreation(String planBranchCreation) {
        this.planBranchCreation = planBranchCreation;
    }

    public boolean isMergeCapable() {
        return this.defaultRepositoryModuleDescriptor != null && this.defaultRepositoryModuleDescriptor.supportsMerging();
    }

    public String getDefaultRepositoryType() {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.defaultRepositoryModuleDescriptor;
        if (moduleDescriptor != null) {
            return moduleDescriptor.getName();
        }
        return "Unknown";
    }

    public VcsUIConfigBean.VcsHtmlFragments getRepositoryEditHtml() {
        return this.repositoryEditHtml;
    }

    public String getPlanBranchCreationRegularExpression() {
        return this.planBranchCreationRegularExpression;
    }

    public void setPlanBranchCreationRegularExpression(String planBranchCreationRegularExpression) {
        this.planBranchCreationRegularExpression = planBranchCreationRegularExpression;
    }

    public String getRemovedBranchCleanUpPeriodInDays() {
        return this.removedBranchCleanUpPeriodInDays;
    }

    public void setRemovedBranchCleanUpPeriodInDays(String removedBranchCleanUpPeriodInDays) {
        this.removedBranchCleanUpPeriodInDays = removedBranchCleanUpPeriodInDays;
    }

    public void setInactiveBranchCleanUpPeriodInDays(String inactiveBranchCleanUpPeriodInDays) {
        this.inactiveBranchCleanUpPeriodInDays = inactiveBranchCleanUpPeriodInDays;
    }

    public String getInactiveBranchCleanUpPeriodInDays() {
        return this.inactiveBranchCleanUpPeriodInDays;
    }

    public List<BranchCreationType> getBranchCreationTypes() {
        boolean isBranchAware = this.isBranchDetectionCapable();
        boolean isPRAware = this.isPullRequestAware();
        return Arrays.stream(BranchCreationType.values()).filter(type -> type.isBranchAware() && isBranchAware || type.isPullRequestAware() && isPRAware).collect(Collectors.toList());
    }

    public List<BranchTriggeringOption> getBranchTriggeringOptions() {
        return ImmutableList.copyOf((Object[])BranchTriggeringOption.values());
    }

    public String getDefaultNotificationStrategy() {
        return this.defaultNotificationStrategy;
    }

    public void setDefaultNotificationStrategy(String defaultNotificationStrategy) {
        this.defaultNotificationStrategy = defaultNotificationStrategy;
    }

    public boolean isBranchDetectionCapable() {
        return this.defaultRepositoryModuleDescriptor != null && this.defaultRepositoryModuleDescriptor.supportsBranchDetection();
    }

    public boolean isPullRequestAware() {
        return this.isBranchDetectionCapable() && this.defaultRepositoryModuleDescriptor.supportsPullRequestDetection();
    }

    public List<BranchNotificationStrategy> getNotificationStrategies() {
        return ImmutableList.copyOf((Object[])BranchNotificationStrategy.values());
    }

    public boolean isRemoteJiraBranchLinkingEnabled() {
        return this.remoteJiraBranchLinkingEnabled;
    }

    public void setRemoteJiraBranchLinkingEnabled(boolean remoteJiraBranchLinkingEnabled) {
        this.remoteJiraBranchLinkingEnabled = remoteJiraBranchLinkingEnabled;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean getDeletePlanBranchWhenBranchRemovedFromVcs() {
        return this.deletePlanBranchWhenBranchRemovedFromVcs;
    }

    public void setDeletePlanBranchWhenBranchRemovedFromVcs(boolean deletePlanBranchWhenBranchRemovedFromVcs) {
        this.deletePlanBranchWhenBranchRemovedFromVcs = deletePlanBranchWhenBranchRemovedFromVcs;
    }

    public boolean getDeletePlanBranchWhenBranchIsInactiveInVcs() {
        return this.deletePlanBranchWhenBranchIsInactiveInVcs;
    }

    public void setDeletePlanBranchWhenBranchIsInactiveInVcs(boolean deletePlanBranchWhenBranchIsInactiveInVcs) {
        this.deletePlanBranchWhenBranchIsInactiveInVcs = deletePlanBranchWhenBranchIsInactiveInVcs;
    }

    public String getBranchTriggering() {
        return this.branchTriggering;
    }

    public void setBranchTriggering(String branchTriggering) {
        this.branchTriggering = branchTriggering;
    }

    public List<RepositoryTriggerSelector> getRepositoryTriggerSelectors() {
        BranchMonitoringConfiguration monitoringConfiguration = this.getImmutablePlan().getBuildDefinition().getBranchMonitoringConfiguration();
        TriggerDefinition existingTrigger = monitoringConfiguration.getDefaultTrigger();
        return this.getRepositoryTriggerSelectors(existingTrigger);
    }
}

