/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import org.jetbrains.annotations.Nullable;

public enum BranchCreationType {
    MANUAL("manually", true, false, PlanBranchWorkflow.MANUAL_WORKFLOW),
    PR("pr", false, true, PlanBranchWorkflow.PULL_REQUEST_WORKFLOW),
    NEW_VCS_BRANCH("new_vcs_branch", true, false, PlanBranchWorkflow.BRANCH_WORKFLOW),
    NEW_MATCHING_VCS_BRANCH("matching_vcs_branch", true, false, PlanBranchWorkflow.BRANCH_WORKFLOW);

    private final String key;
    private final boolean isBranchAware;
    private final boolean isPullRequestAware;
    private final PlanBranchWorkflow compatiblePlanBranchWorkflow;

    private BranchCreationType(String key, boolean isBranchAware, boolean isPullRequestAware, PlanBranchWorkflow integrationStrategies) {
        this.key = key;
        this.isBranchAware = isBranchAware;
        this.isPullRequestAware = isPullRequestAware;
        this.compatiblePlanBranchWorkflow = integrationStrategies;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isBranchAware() {
        return this.isBranchAware;
    }

    public boolean isPullRequestAware() {
        return this.isPullRequestAware;
    }

    public PlanBranchWorkflow getCompatiblePlanBranchWorkflow() {
        return this.compatiblePlanBranchWorkflow;
    }

    public static BranchCreationType byKey(@Nullable String key) {
        for (BranchCreationType type : BranchCreationType.values()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return MANUAL;
    }
}

