/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.branch;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerConfigurator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.ww2.actions.ChainActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.RepositoryTriggerSelector;
import com.atlassian.bamboo.ww2.actions.chains.admin.triggers.TriggerUIConfigBean;
import com.atlassian.bamboo.ww2.aware.BuildConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBranchTriggerConfigAction
extends ChainActionSupport
implements BuildConfigurationAware,
PlanEditSecurityAware {
    protected static final String MANUAL_STRATEGY = "manualOnly";
    private static final Logger log = Logger.getLogger(AbstractBranchTriggerConfigAction.class);
    protected List<TriggerUIConfigBean.TriggerSelector> triggerSelectors;
    protected Iterable<TriggerModuleDescriptor> triggerModuleDescriptors;
    protected Long[] repositoryTrigger;
    protected List<RepositoryTriggerSelector> repositoryTriggerSelectors;
    @Inject
    protected TriggerTypeManager triggerTypeManager;
    @Inject
    protected TriggerUIConfigBean triggerUIConfigBean;
    protected BuildConfiguration buildConfiguration;

    public void setTriggerUIConfigBean(TriggerUIConfigBean triggerUIConfigBean) {
        this.triggerUIConfigBean = triggerUIConfigBean;
    }

    public void setTriggerTypeManager(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }

    public void setRepositoryTrigger(Long[] repositoryTrigger) {
        this.repositoryTrigger = repositoryTrigger;
    }

    protected void validateTriggerConfiguration() {
        String selectedStrategy = this.buildConfiguration.getString("selectedBuildStrategy", MANUAL_STRATEGY);
        if (!selectedStrategy.equals(MANUAL_STRATEGY)) {
            TriggerModuleDescriptor triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(selectedStrategy);
            if (triggerModuleDescriptor != null) {
                TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
                this.triggerUIConfigBean.validateTriggerConfiguration(triggerModuleDescriptor, this);
            } else {
                this.addFieldError("selectedBuildStrategy", this.getText("chain.trigger.invalid.plugin"));
            }
        }
    }

    protected void renderTriggerEditHtmlsWithErrors() {
        this.triggerModuleDescriptors = this.triggerTypeManager.getAvailableTriggerDescriptors((Triggerable)this.getImmutableChain());
        this.triggerSelectors = new ArrayList<TriggerUIConfigBean.TriggerSelector>();
        for (TriggerModuleDescriptor triggerModuleDescriptor : this.triggerModuleDescriptors) {
            TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
            if (triggerConfigurator == null) continue;
            this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector(triggerModuleDescriptor.getCompleteKey(), triggerModuleDescriptor.getName(), triggerModuleDescriptor.getDescription(), this.triggerUIConfigBean.prepareCreateHtml(triggerModuleDescriptor, TaskRenderMode.ERROR, (Triggerable)this.getImmutableChain())));
        }
    }

    @NotNull
    protected Map<String, String> triggerConditionsConfigurationFromInput() {
        return TriggerConfigurationUtils.extractTriggerConditionConfiguration((HierarchicalConfiguration)this.buildConfiguration);
    }

    @Nullable
    protected Set<Long> triggeringRepositoriesFromInput(TriggerModuleDescriptor triggerDescriptor) {
        Set<Long> triggeringRepositories = null;
        if (this.repositoryTrigger != null && this.isUseStandardRepositorySelector(triggerDescriptor)) {
            triggeringRepositories = new HashSet<Long>(Arrays.asList(this.repositoryTrigger));
        } else if (this.useAllRepositories(triggerDescriptor)) {
            triggeringRepositories = this.getImmutableChain().getPlanRepositoryDefinitions().stream().map(BambooIdProvider::getId).collect(Collectors.toSet());
        }
        return triggeringRepositories;
    }

    boolean isUseStandardRepositorySelector(TriggerModuleDescriptor triggerDescriptor) {
        return triggerDescriptor.getTriggerConfigurator() != null && TriggerConfigurator.RepositorySelectionMode.SELECTED.equals((Object)triggerDescriptor.getTriggerConfigurator().getRepositorySelectionMode());
    }

    private boolean useAllRepositories(TriggerModuleDescriptor triggerDescriptor) {
        return triggerDescriptor.getTriggerConfigurator() != null && TriggerConfigurator.RepositorySelectionMode.ALL.equals((Object)triggerDescriptor.getTriggerConfigurator().getRepositorySelectionMode());
    }

    protected void prepareTriggerEditHtmls(TriggerDefinition triggerDefinition) {
        for (TriggerModuleDescriptor triggerModuleDescriptor : this.triggerModuleDescriptors) {
            TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
            if (triggerConfigurator == null) continue;
            if (triggerDefinition != null && triggerModuleDescriptor.getCompleteKey().equals(triggerDefinition.getPluginKey())) {
                this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector(triggerModuleDescriptor.getCompleteKey(), triggerModuleDescriptor.getName(), triggerModuleDescriptor.getDescription(), this.triggerUIConfigBean.prepareEditHtml(triggerModuleDescriptor, triggerDefinition, TaskRenderMode.SUCCESS, (Triggerable)this.getImmutableChain())));
                continue;
            }
            this.triggerSelectors.add(new TriggerUIConfigBean.TriggerSelector(triggerModuleDescriptor.getCompleteKey(), triggerModuleDescriptor.getName(), triggerModuleDescriptor.getDescription(), this.triggerUIConfigBean.prepareCreateHtml(triggerModuleDescriptor, TaskRenderMode.SUCCESS, (Triggerable)this.getImmutableChain())));
        }
    }

    public String getKeysOfTriggersExpectingRepository() {
        StringBuilder builder = new StringBuilder();
        for (TriggerModuleDescriptor triggerModuleDescriptor : this.triggerModuleDescriptors) {
            TriggerConfigurator triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator();
            if (triggerConfigurator == null || TriggerConfigurator.RepositorySelectionMode.SELECTED != triggerConfigurator.getRepositorySelectionMode()) continue;
            builder.append(triggerModuleDescriptor.getCompleteKey()).append(' ');
        }
        return builder.toString();
    }

    protected List<RepositoryTriggerSelector> getRepositoryTriggerSelectors(@Nullable TriggerDefinition existingTrigger) {
        if (this.repositoryTriggerSelectors == null) {
            if (this.repositoryTrigger != null) {
                HashSet<Long> triggeringRepositories = new HashSet<Long>(Arrays.asList(this.repositoryTrigger));
                this.repositoryTriggerSelectors = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.getImmutableChain().getPlanRepositoryDefinitions(), (Function)new RepositoryTriggerSelector.Transform2TriggerSelector(triggeringRepositories)));
            } else {
                boolean initialized = this.initialiseRepositorySelectorsFromExistingTrigger(existingTrigger);
                if (!initialized) {
                    this.repositoryTriggerSelectors = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.getImmutableChain().getPlanRepositoryDefinitions(), (Function)new RepositoryTriggerSelector.Transform2TriggerSelector()));
                }
            }
        }
        return this.repositoryTriggerSelectors;
    }

    protected boolean initialiseRepositorySelectorsFromExistingTrigger(TriggerDefinition existingTrigger) {
        TriggerConfigurator triggerConfigurator;
        TriggerModuleDescriptor triggerModuleDescriptor;
        Set<Long> triggeringRepositories = new HashSet();
        if (existingTrigger != null && (triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(existingTrigger.getPluginKey())) != null && (triggerConfigurator = triggerModuleDescriptor.getTriggerConfigurator()) != null && TriggerConfigurator.RepositorySelectionMode.SELECTED == triggerConfigurator.getRepositorySelectionMode()) {
            triggeringRepositories = existingTrigger.getTriggeringRepositories();
            ImmutableChain master = this.getImmutableChain().hasMaster() ? this.getImmutableChain().getMaster() : this.getImmutableChain();
            PlanRepositoryDefinition masterDefault = (PlanRepositoryDefinition)Iterables.getFirst((Iterable)master.getPlanRepositoryDefinitions(), null);
            if (masterDefault != null && triggeringRepositories.contains(masterDefault.getId())) {
                triggeringRepositories.add(((PlanRepositoryDefinition)this.getImmutableChain().getPlanRepositoryDefinitions().get(0)).getId());
            }
            this.repositoryTriggerSelectors = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.getImmutableChain().getPlanRepositoryDefinitions(), (Function)new RepositoryTriggerSelector.Transform2TriggerSelector(triggeringRepositories)));
            return true;
        }
        return false;
    }

    public List<TriggerUIConfigBean.TriggerSelector> getTriggerSelectors() {
        return this.triggerSelectors;
    }
}

