/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.author.collector.AbstractAuthorReportCollector;
import com.atlassian.bamboo.author.collector.AuthorBuildsBrokenCollector;
import com.atlassian.bamboo.author.collector.AuthorBuildsFailedCollector;
import com.atlassian.bamboo.author.collector.AuthorBuildsFixedCollector;
import com.atlassian.bamboo.author.collector.AuthorBuildsTriggeredCollector;
import com.atlassian.bamboo.author.collector.AuthorSuccessRatioCollector;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.reports.ReportHelper;
import com.atlassian.bamboo.ww2.beans.author.DecoratedAuthorBuildStatistics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.time.TimeTableXYDataset;

public class ViewAuthors
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewAuthors.class);
    private List<Author> authors;
    private ExtendedAuthorManager extendedAuthorManager;
    private TimeTableXYDataset dataset;
    private List<DecoratedAuthorBuildStatistics> authorsBuildStatistics;
    List<String> selectedAuthorNames;
    String groupByPeriod = "AUTO";
    String reportKey;
    String resolvedAutoPeriod;
    Map<String, String> availableReports;
    Map<String, String> availableGroupBy;
    public static final String REPORT_NUM_FAILURES = "authors.report.numberOfFailures";
    public static final String REPORT_RATIO_SUCCESS = "authors.report.ratioOfSuccesses";
    public static final String REPORT_NUM_BUILDS = "authors.report.numberOfBuilds";
    public static final String REPORT_NUM_BROKEN = "authors.report.numberOfBrokenBuilds";
    public static final String REPORT_NUM_FIXED = "authors.report.numberOfFixedBuilds";
    public static final String AUTHOR_PREFIX = "author";
    public static final String REPORT_KEY = "reportKey";
    public static final String AUTHOR_NAME = "selectedAuthorNames";

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.reportKey)) {
            this.addFieldError(REPORT_KEY, this.getText("author.statistic.report.empty"));
        }
        if (CollectionUtils.isEmpty(this.selectedAuthorNames)) {
            this.addFieldError(AUTHOR_NAME, this.getText("author.statistic.author.empty"));
        }
    }

    public String read() {
        if (this.getCookieCutter() != null) {
            this.getCookieCutter().saveValueInCookie("bamboo.author.view", "report");
        }
        return "success";
    }

    public String list() {
        if (this.getCookieCutter() != null) {
            this.getCookieCutter().saveValueInCookie("bamboo.author.view", "list");
        }
        return "success";
    }

    public String generate() {
        AbstractAuthorReportCollector report = this.getReportCollector();
        if (!CollectionUtils.isEmpty(this.getAuthors()) && report != null && !CollectionUtils.isEmpty(this.selectedAuthorNames)) {
            HashMap<String, List<ResultsSummary>> resultsMap = new HashMap<String, List<ResultsSummary>>();
            for (Author author : this.getAuthors()) {
                String authorName = author.getName();
                if (!this.selectedAuthorNames.contains(authorName)) continue;
                List results = Comparators.getBuildDateOrdering().sortedCopy((Iterable)author.getAllTriggeredBuildResults());
                resultsMap.put(authorName, results);
            }
            AbstractAuthorReportCollector collector = report;
            collector.setAuthorBuilds(resultsMap);
            collector.setParams(ActionParamsUtils.getStringArrayMap());
            this.dataset = (TimeTableXYDataset)collector.getDataSet();
            this.resolvedAutoPeriod = collector.getPeriodRange();
        }
        return "success";
    }

    @Nullable
    private AbstractAuthorReportCollector getReportCollector() {
        if (REPORT_NUM_FAILURES.equals(this.getReportKey())) {
            return new AuthorBuildsFailedCollector();
        }
        if (REPORT_RATIO_SUCCESS.equals(this.getReportKey())) {
            return new AuthorSuccessRatioCollector();
        }
        if (REPORT_NUM_BUILDS.equals(this.getReportKey())) {
            return new AuthorBuildsTriggeredCollector();
        }
        if (REPORT_NUM_BROKEN.equals(this.getReportKey())) {
            return new AuthorBuildsBrokenCollector();
        }
        if (REPORT_NUM_FIXED.equals(this.getReportKey())) {
            return new AuthorBuildsFixedCollector();
        }
        return null;
    }

    @NotNull
    public List<Author> getAuthors() {
        if (this.authors == null) {
            this.authors = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.extendedAuthorManager.getAllAuthors());
        }
        return this.authors;
    }

    @NotNull
    public List<DecoratedAuthorBuildStatistics> getAuthorsBuildStatistics() {
        if (this.authorsBuildStatistics == null) {
            this.authorsBuildStatistics = this.getAuthors().stream().map(DecoratedAuthorBuildStatistics::new).collect(Collectors.toList());
        }
        return this.authorsBuildStatistics;
    }

    @NotNull
    public Map<String, String> getAvailableReports() {
        if (this.availableReports == null) {
            this.availableReports = new LinkedHashMap<String, String>();
            this.availableReports.put(REPORT_NUM_BUILDS, "Build Activity");
            this.availableReports.put(REPORT_NUM_FAILURES, "Number of Build Failures");
            this.availableReports.put(REPORT_NUM_BROKEN, "Number of Builds Broken");
            this.availableReports.put(REPORT_NUM_FIXED, "Number of Builds Fixed");
            this.availableReports.put(REPORT_RATIO_SUCCESS, "Percentage of Successful Builds");
        }
        return this.availableReports;
    }

    @NotNull
    public Map<String, String> getAvailableGroupBy() {
        if (this.availableGroupBy == null) {
            this.availableGroupBy = ReportHelper.getGroupByDateOptions();
        }
        return this.availableGroupBy;
    }

    public TimeTableXYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(TimeTableXYDataset dataset) {
        this.dataset = dataset;
    }

    public List<String> getSelectedAuthorNames() {
        return this.selectedAuthorNames;
    }

    public void setSelectedAuthorNames(List<String> selectedAuthorNames) {
        this.selectedAuthorNames = selectedAuthorNames;
    }

    public String getGroupByPeriod() {
        return this.groupByPeriod;
    }

    public void setGroupByPeriod(String groupByPeriod) {
        this.groupByPeriod = groupByPeriod;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public String getResolvedAutoPeriod() {
        return this.resolvedAutoPeriod;
    }

    public void setResolvedAutoPeriod(String resolvedAutoPeriod) {
        this.resolvedAutoPeriod = resolvedAutoPeriod;
    }

    @Nullable
    public Double getYValue(int series, int item) {
        double value = this.dataset.getYValue(series, item);
        return Double.isNaN(value) ? null : Double.valueOf(value);
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }
}

