/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ViewAuthor
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewAuthor.class);
    private Author author;
    private String authorName;
    private ExtendedAuthorManager extendedAuthorManager;

    public String input() throws Exception {
        if (this.getAuthor() != null) {
            return "input";
        }
        this.addActionError(this.getText("author.error.notfound", new String[]{this.authorName}));
        return "error";
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public List<ResultsSummary> getResultsList() {
        return this.getAuthor().getTriggeredBuildResults().stream().sorted(Comparators.getBuildDateOrdering().reversed()).collect(Collectors.toList());
    }

    public Author getAuthor() {
        if (this.author == null) {
            this.author = this.extendedAuthorManager.getAuthorByName(this.getAuthorName());
        }
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }
}

