/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.beans.author.DecoratedUserBuildStatistics;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAggregatedAuthors
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewAggregatedAuthors.class);
    private List<DecoratedUserBuildStatistics> usersBuildStatistics;
    private ExtendedAuthorManager extendedAuthorManager;

    @NotNull
    public List<DecoratedUserBuildStatistics> getUsersBuildStatistics() {
        if (this.usersBuildStatistics == null) {
            HashSet<String> userNames = new HashSet<String>();
            for (Author author : this.extendedAuthorManager.getAllAuthors()) {
                String linkedUserName = author.getLinkedUserName();
                if (linkedUserName == null) continue;
                userNames.add(linkedUserName);
            }
            this.usersBuildStatistics = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(userNames, (Function)new GetUserByName(this.bambooUserManager)), (Predicate)Predicates.notNull()), DecoratedUserBuildStatistics.createFromUser(this.extendedAuthorManager)));
        }
        return this.usersBuildStatistics;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    private static class GetUserByName
    implements Function<String, User> {
        private final BambooUserManager bambooUserManager;

        private GetUserByName(BambooUserManager bambooUserManager) {
            this.bambooUserManager = bambooUserManager;
        }

        public User apply(@Nullable String input) {
            if (input != null) {
                return this.bambooUserManager.getUser(input);
            }
            return null;
        }
    }
}

