/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.agent;

import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;

public class ViewAgentDetailsAction
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private AgentManager agentManager;
    private ElasticInstanceManager elasticInstanceManager;
    private BuildAgent buildAgent;
    private PipelineDefinition agent;
    private RemoteElasticInstance remoteElasticInstance;
    private RemoteEC2Instance instance;
    private long agentId;
    private String showOptions;
    private String showStatus;

    public String view() throws Exception {
        if (this.agentId == 0L) {
            this.addActionError("You need to provide agentId .");
            return "error";
        }
        this.buildAgent = this.agentManager.getAgent(this.agentId);
        if (this.buildAgent == null) {
            this.addActionError("No agent with the given id.");
            return "error";
        }
        this.agent = this.buildAgent.getDefinition();
        if (this.agent != null) {
            this.agent.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    String instanceId = pipelineDefinition.getElasticInstanceId();
                    ViewAgentDetailsAction.this.remoteElasticInstance = ViewAgentDetailsAction.this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(instanceId);
                    if (ViewAgentDetailsAction.this.remoteElasticInstance != null) {
                        ViewAgentDetailsAction.this.instance = ViewAgentDetailsAction.this.remoteElasticInstance.getInstance();
                    }
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                }
            });
        }
        return "success";
    }

    public RemoteEC2Instance getInstance() {
        return this.instance;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public PipelineDefinition getAgent() {
        return this.agent;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public String getShowOptions() {
        return this.showOptions;
    }

    public void setShowOptions(String showOptions) {
        this.showOptions = showOptions;
    }

    public String getShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(String showStatus) {
        this.showStatus = showStatus;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }
}

