/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.agent;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;

public class ElasticImageDecorator {
    private final String id;
    private final String hostname;
    private final boolean agentLoading;
    private final String state;
    private final String amiId;
    private final boolean ebsEnabled;
    private final String instanceType;
    private final String configurationName;

    public ElasticImageDecorator(RemoteElasticInstance from) {
        this.id = from.getInstance().getInstanceId();
        this.hostname = from.getInstance().getInstanceStatus().getHostname();
        this.agentLoading = from.isAgentLoading();
        this.state = from.getState().name();
        this.amiId = from.getConfiguration().getAmiId();
        this.ebsEnabled = from.getConfiguration().isEbsEnabled();
        EC2InstanceType instanceTypeEnum = EC2InstanceType.from((InstanceType)from.getInstance().getInstanceStatus().getInstanceType());
        this.instanceType = instanceTypeEnum.name();
        this.configurationName = from.getConfiguration().getConfigurationName();
    }

    public String getID() {
        return this.id;
    }

    public String getAddress() {
        return this.hostname;
    }

    public String getState() {
        return this.state;
    }

    public boolean isAgentLoading() {
        return this.agentLoading;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public boolean isEbsEnabled() {
        return this.ebsEnabled;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }
}

