/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.agent;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildAgentDecorator
implements BuildAgent {
    private static final Logger log = Logger.getLogger(BuildAgentDecorator.class);
    private final long id;
    private final String name;
    private final boolean active;
    private final boolean enabled;
    private final AgentStatus agentStatus;
    private final boolean requestedToBeStopped;
    private final boolean unresponsive;
    private final boolean isBusy;
    private final AgentType type;
    private final boolean dedicated;
    public static Function<BuildAgent, BuildAgentDecorator> toDecorator = input -> input != null ? new BuildAgentDecorator((BuildAgent)input) : null;

    public BuildAgentDecorator(@NotNull BuildAgent buildAgent) {
        this.id = buildAgent.getId();
        this.name = buildAgent.getName();
        this.active = buildAgent.isActive();
        this.enabled = buildAgent.isEnabled();
        this.agentStatus = buildAgent.getAgentStatus();
        this.requestedToBeStopped = buildAgent.isRequestedToBeStopped();
        this.unresponsive = buildAgent.isUnresponsive();
        this.isBusy = buildAgent.isBusy();
        this.type = buildAgent.getDefinition().getType();
        this.dedicated = buildAgent.isDedicated();
    }

    @NotNull
    public JSONObject getJson(boolean includeAllProperties) {
        JSONObject jsonAgentObject = new JSONObject();
        try {
            jsonAgentObject.put("id", this.id);
            jsonAgentObject.put("name", (Object)this.name);
            jsonAgentObject.put("type", (Object)this.type);
            if (includeAllProperties) {
                jsonAgentObject.put("enabled", this.enabled);
                jsonAgentObject.put("active", this.active);
                jsonAgentObject.put("agentStatus", (Object)this.agentStatus.toString());
                if (this.agentStatus instanceof AgentBuildingStatus) {
                    AgentBuildingStatus status = (AgentBuildingStatus)this.agentStatus;
                    jsonAgentObject.put("buildResultKey", (Object)status.getResultKey());
                    jsonAgentObject.put("buildLogUrl", (Object)this.agentStatus.getUrl());
                    jsonAgentObject.put("buildDisplayName", (Object)this.agentStatus.getDisplayName());
                }
                jsonAgentObject.put("requestedToBeStopped", this.requestedToBeStopped);
                jsonAgentObject.put("unresponsive", this.unresponsive);
                jsonAgentObject.put("isBusy", this.isBusy);
                jsonAgentObject.put("isDedicated", this.dedicated);
            }
            return jsonAgentObject;
        }
        catch (JSONException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @NotNull
    public JSONObject getJson() throws JSONException {
        return this.getJson(false);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public AgentStatus getAgentStatus() {
        return this.agentStatus;
    }

    @NotNull
    public PipelineDefinition getDefinition() {
        throw new UnsupportedOperationException("This is only a build agent decorator not a real agent!");
    }

    public void setDefinition(@NotNull PipelineDefinition definition) {
        throw new UnsupportedOperationException("This is only a build agent decorator not a real agent!");
    }

    public boolean isRequestedToBeStopped() {
        return this.requestedToBeStopped;
    }

    public void setRequestedToBeStopped(boolean requestedToBeStopped) {
        throw new UnsupportedOperationException("This is only a build agent decorator not a real agent!");
    }

    public void accept(BuildAgent.BuildAgentVisitor buildAgentVisitor) {
        throw new UnsupportedOperationException("This is only a build agent decorator not a real agent!");
    }

    public boolean isUnresponsive() {
        return this.unresponsive;
    }

    public void setUnresponsive(boolean unresponsive) {
        throw new UnsupportedOperationException("This is only a build agent decorator not a real agent!");
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public int compareTo(BuildAgent buildAgent) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)buildAgent.getName()).append(this.getId(), buildAgent.getId()).toComparison();
    }

    public AgentType getType() {
        return this.type;
    }

    public boolean isDedicated() {
        return this.dedicated;
    }
}

