/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.agent.BuildAgentDecorator;
import com.atlassian.bamboo.ww2.actions.agent.ElasticImageDecorator;
import com.google.common.collect.Iterables;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AgentJsonProvider
extends BambooActionSupport {
    private boolean onlineOnly;
    private boolean includeInstances;
    private boolean includeRemoteAgentSummary;
    private AgentManager agentManager;
    private ElasticInstanceManager elasticInstanceManager;
    private List<BuildAgent> buildAgents;
    private List<RemoteElasticInstance> remoteElasticInstances;

    private static boolean isAgentPending(RemoteElasticInstance instance) {
        RemoteElasticInstanceState state = instance.getState();
        return state == RemoteElasticInstanceState.IDENTIFIED || state == RemoteElasticInstanceState.STARTING || instance.isAgentLoading();
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        jsonObject.put("agents", this.getJsonAgents());
        if (this.includeInstances) {
            jsonObject.put("instances", this.getJsonInstances());
        }
        if (this.includeRemoteAgentSummary) {
            jsonObject.put("remoteAgentSummary", (Object)this.getRemoteAgentSummary());
        }
        return jsonObject;
    }

    private List<JSONObject> getJsonAgents() {
        return this.getBuildAgents().stream().filter(buildAgent -> !this.onlineOnly || buildAgent.isActive()).map(BuildAgentDecorator::new).map(decorator -> decorator.getJson(true)).collect(Collectors.toList());
    }

    private Collection<JSONObject> getJsonInstances() {
        return this.getRemoteElasticInstances().stream().filter(AgentJsonProvider::isAgentPending).map(ElasticImageDecorator::new).map(AgentJsonProvider::asJsonObject).collect(Collectors.toList());
    }

    private static JSONObject asJsonObject(Object o) {
        JSONObject jsonObject = new JSONObject(o);
        jsonObject.remove("class");
        return jsonObject;
    }

    private String getRemoteAgentSummary() {
        boolean isElasticConfigEnabled;
        String endManageElasticLink;
        String startManageElasticLink;
        Collection pendingRemoteElasticInstances = this.getRemoteElasticInstances().stream().filter(AgentJsonProvider::isAgentPending).collect(Collectors.toList());
        final ArrayList onlineRemoteAgents = new ArrayList();
        final ArrayList onlineElasticAgents = new ArrayList();
        for (final BuildAgent buildAgent : Iterables.filter(this.getBuildAgents(), BuildAgentPredicates::isActive)) {
            buildAgent.getDefinition().accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    onlineElasticAgents.add(buildAgent);
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    onlineRemoteAgents.add(buildAgent);
                }
            });
        }
        int numberOfOnlineRemoteAgents = onlineRemoteAgents.size();
        int numberOfOnlineElasticAgents = onlineElasticAgents.size();
        int numberOfOnlineRemoteAndElasticAgents = numberOfOnlineRemoteAgents + numberOfOnlineElasticAgents;
        int numberOfRequestedElasticAgents = pendingRemoteElasticInstances.size();
        if (this.bambooPermissionManager.canManageElasticBamboo()) {
            startManageElasticLink = "<a href=\"" + RequestCacheThreadLocal.getContextPath() + "/admin/elastic/manageElasticInstances.action\">";
            endManageElasticLink = "</a>";
        } else {
            startManageElasticLink = "";
            endManageElasticLink = "";
        }
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        boolean bl = isElasticConfigEnabled = administrationConfiguration.getElasticConfig() != null && administrationConfiguration.getElasticConfig().isEnabled();
        if (numberOfOnlineRemoteAndElasticAgents == 0) {
            if (!isElasticConfigEnabled) {
                return this.getText("agent.remote.numberOnline.none");
            }
            return this.getText("agent.remote.numberOnline.none.elastic", Arrays.asList(numberOfRequestedElasticAgents, startManageElasticLink, endManageElasticLink));
        }
        if (isElasticConfigEnabled) {
            int allowedNumberOfRemoteAgents = this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents();
            if (numberOfOnlineElasticAgents != 0) {
                if (numberOfOnlineRemoteAndElasticAgents != numberOfOnlineElasticAgents) {
                    return this.getText("agent.remote.numberOnline.elasticEnabled", Arrays.asList(numberOfOnlineRemoteAndElasticAgents, numberOfOnlineRemoteAgents, numberOfOnlineElasticAgents, numberOfRequestedElasticAgents, allowedNumberOfRemoteAgents, startManageElasticLink, endManageElasticLink));
                }
                return this.getText("agent.remote.numberOnline.elasticEnabled.onlyElasticOnline", Arrays.asList(numberOfOnlineRemoteAndElasticAgents, numberOfRequestedElasticAgents, allowedNumberOfRemoteAgents, startManageElasticLink, endManageElasticLink));
            }
            return this.getText("agent.remote.numberOnline.elasticEnabled.noElasticOnline", Arrays.asList(numberOfOnlineRemoteAndElasticAgents, numberOfRequestedElasticAgents, allowedNumberOfRemoteAgents, startManageElasticLink, endManageElasticLink));
        }
        return this.getText("agent.remote.numberOnline", Arrays.asList(numberOfOnlineRemoteAndElasticAgents));
    }

    @NotNull
    private Collection<BuildAgent> getBuildAgents() {
        if (this.buildAgents == null) {
            this.buildAgents = this.agentManager.getAllAgents();
            Collections.sort(this.buildAgents);
        }
        return this.buildAgents;
    }

    @NotNull
    public Collection<RemoteElasticInstance> getRemoteElasticInstances() {
        if (this.remoteElasticInstances == null) {
            this.remoteElasticInstances = this.elasticInstanceManager.getElasticRemoteAgents();
        }
        return this.remoteElasticInstances;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setElasticInstanceManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }

    public void setOnlineOnly(boolean onlineOnly) {
        this.onlineOnly = onlineOnly;
    }

    public void setIncludeInstances(boolean includeInstances) {
        this.includeInstances = includeInstances;
    }

    public void setIncludeRemoteAgentSummary(boolean includeRemoteAgentSummary) {
        this.includeRemoteAgentSummary = includeRemoteAgentSummary;
    }
}

