/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.agent;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.web.Jsonate;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentAssignmentExecutableDetails
implements Comparable<AgentAssignmentExecutableDetails> {
    private long id;
    private AgentAssignment.ExecutableType type;
    private String name;
    private String parentName;
    private boolean capabilitiesMatch;

    public AgentAssignmentExecutableDetails(@NotNull DeploymentProject deploymentProject) {
        this.id = deploymentProject.getId();
        this.type = AgentAssignment.ExecutableType.DEPLOYMENT_PROJECT;
        this.name = deploymentProject.getName();
        this.capabilitiesMatch = false;
    }

    public AgentAssignmentExecutableDetails(@NotNull Environment environment, @Nullable DeploymentProject deploymentProject, boolean capabilitiesMatch) {
        this.id = environment.getId();
        this.type = AgentAssignment.ExecutableType.ENVIRONMENT;
        this.name = environment.getName();
        if (deploymentProject != null) {
            this.parentName = deploymentProject.getName();
        }
        this.capabilitiesMatch = capabilitiesMatch;
    }

    public AgentAssignmentExecutableDetails(@NotNull Job job, @Nullable Plan plan, boolean capabilitiesMatch) {
        this.id = job.getId();
        this.type = AgentAssignment.ExecutableType.JOB;
        this.name = job.getBuildName();
        if (plan != null) {
            this.parentName = job.getProject().getName() + " &rsaquote; " + plan.getBuildName();
        }
        this.capabilitiesMatch = capabilitiesMatch;
    }

    public AgentAssignmentExecutableDetails(@NotNull Project project) {
        this.id = project.getId();
        this.type = AgentAssignment.ExecutableType.PROJECT;
        this.name = project.getName();
        this.capabilitiesMatch = false;
    }

    public AgentAssignmentExecutableDetails(@NotNull Chain chain, @Nullable Project project) {
        this.id = chain.getId();
        this.type = AgentAssignment.ExecutableType.PLAN;
        this.name = chain.getBuildName();
        if (project != null) {
            this.parentName = project.getName();
        }
        this.capabilitiesMatch = false;
    }

    @Jsonate
    public long getId() {
        return this.id;
    }

    @Jsonate
    public AgentAssignment.ExecutableType getType() {
        return this.type;
    }

    @Jsonate
    public String getTypeLabel() {
        return this.type.getLabel();
    }

    @Jsonate
    public String getName() {
        return this.name;
    }

    @Jsonate
    public String getParentName() {
        return this.parentName;
    }

    @Jsonate
    public boolean isCapabilitiesMatch() {
        return this.capabilitiesMatch;
    }

    @Override
    public int compareTo(AgentAssignmentExecutableDetails obj) {
        return new CompareToBuilder().append((Object)this.type, (Object)obj.type).append((Object)this.parentName, (Object)obj.parentName).append((Object)this.name, (Object)obj.name).toComparison();
    }
}

