/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.webhook;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.webhook.WebhookTemplate;
import com.atlassian.bamboo.webhook.WebhookTemplateEntity;
import com.atlassian.bamboo.webhook.WebhookTemplateService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;

public class ConfigureWebhookTemplates
extends GlobalAdminAction {
    private HttpMethod httpMethod;
    private String headers;
    private String payload;
    private String name;
    private WebhookTemplateService webhookTemplateService;
    private long lastModified;
    private String redirectUrl;
    private Long webhookId;

    public String execute() {
        return "input";
    }

    public String add() {
        this.validateWebhookTemplate();
        this.validateUniqueName();
        if (this.hasAnyErrors()) {
            return "input";
        }
        try {
            WebhookTemplateEntity.Builder builder = WebhookTemplateEntity.builder().withHttpMethod(this.httpMethod).withHeaders(this.headers).withPayload(this.payload).withName(this.name).withUuid(this.webhookTemplateService.generateUuid());
            WebhookTemplateEntity webhookTemplate = builder.build();
            WebhookTemplate globalWebhookTemplate = this.webhookTemplateService.save((WebhookTemplate)webhookTemplate);
            this.lastModified = globalWebhookTemplate.getId();
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
    }

    public String edit() {
        Optional webhookTemplate = this.webhookTemplateService.findById(this.webhookId.longValue());
        if (!webhookTemplate.isPresent()) {
            this.addActionError("Could not find webhook template with id: " + this.webhookId);
            return "error";
        }
        WebhookTemplate byId = (WebhookTemplate)webhookTemplate.get();
        this.httpMethod = byId.getHttpMethod();
        this.name = byId.getName();
        this.headers = byId.getHeaders();
        this.payload = byId.getPayload();
        this.lastModified = this.webhookId;
        return "input";
    }

    public String update() {
        this.validateWebhookTemplate();
        Optional byId = this.webhookTemplateService.findById(this.webhookId.longValue());
        if (byId.isPresent()) {
            WebhookTemplate webhook = (WebhookTemplate)byId.get();
            if (!Objects.equals(webhook.getName(), this.name)) {
                this.validateUniqueName();
            }
            if (this.hasAnyErrors()) {
                return "input";
            }
            webhook.setHeaders(this.headers);
            webhook.setHttpMethod(this.httpMethod);
            webhook.setPayload(this.payload);
            webhook.setName(this.name);
            this.webhookTemplateService.update(webhook);
            return "success";
        }
        this.addActionError("Could not find webhook template with id: " + this.webhookId);
        return "error";
    }

    public String delete() {
        this.webhookTemplateService.deleteById(this.webhookId.longValue());
        return "success";
    }

    private void validateWebhookTemplate() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            this.addFieldError("name", this.getText("config.webhook.field.empty", Collections.singletonList("Name")));
        }
    }

    private void validateUniqueName() {
        if (this.webhookTemplateService.exists(this.name)) {
            this.addFieldError("name", this.getText("config.webhook.add.name.exists"));
        }
    }

    public List<HttpMethod> getAllowedHttpMethods() {
        return this.webhookTemplateService.getSupportedMethods();
    }

    public List<WebhookTemplate> getGlobalTemplates() {
        return this.webhookTemplateService.getGlobalWebhooks();
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getName() {
        return this.name;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public long getWebhookId() {
        return this.webhookId;
    }

    public void setWebhookId(long webhookId) {
        this.webhookId = webhookId;
    }

    public void setWebhookTemplateService(WebhookTemplateService webhookTemplateService) {
        this.webhookTemplateService = webhookTemplateService;
    }
}

