/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user.signup;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.user.UserAdministrationUtils;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.core.exception.InfrastructureException;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.util.List;
import org.apache.struts2.ServletActionContext;

public class SignupUser
extends BambooActionSupport
implements GlobalBypassSecurityAware {
    private String username;
    private String password;
    private String confirmPassword;
    private String fullName;
    private String email;
    private String jabberAddress;
    private String captcha;
    private ExtendedAuthorManager extendedAuthorManager;
    private static final Supplier<ImageCaptchaService> IMAGE_CAPTCHA_SERVICE = ComponentAccessor.newLazyComponentReference((String)"imageCaptchaService");

    public void validate() {
        if (this.isEnabledCaptchaOnSignup()) {
            boolean isValidCaptcha;
            String captchaId = ServletActionContext.getRequest().getParameter("atl_token");
            try {
                isValidCaptcha = Boolean.TRUE.equals(((ImageCaptchaService)IMAGE_CAPTCHA_SERVICE.get()).validateResponseForID(captchaId, (Object)this.captcha));
            }
            catch (CaptchaServiceException e) {
                isValidCaptcha = false;
            }
            if (!isValidCaptcha) {
                this.addFieldError("captcha", this.getText("user.captcha.error"));
            }
        }
    }

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    public String execute() throws Exception {
        ExtendedAuthor author = (ExtendedAuthor)this.extendedAuthorManager.getAuthorByName(this.username);
        try {
            if (author != null) {
                this.getBambooUserManager().addUser(this.username, this.password, this.email, this.fullName, this.jabberAddress, (List)Lists.newArrayList((Object[])new String[]{"bamboo-user"}), author);
            } else {
                this.getBambooUserManager().addUser(this.username, this.password, this.email, this.fullName, this.jabberAddress, (List)Lists.newArrayList((Object[])new String[]{"bamboo-user"}));
            }
            return "success";
        }
        catch (InfrastructureException e) {
            UserAdministrationUtils.processInfrastructureExceptionForCrowdException(e, this);
            return "error";
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getJabberAddress() {
        return this.jabberAddress;
    }

    public void setJabberAddress(String jabberAddress) {
        this.jabberAddress = jabberAddress;
    }

    public String getCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public boolean isEnabledCaptchaOnSignup() {
        return this.getAdministrationConfiguration().getCaptchaConfiguration().isEnableCaptchaOnSignup();
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager authorManager) {
        this.extendedAuthorManager = authorManager;
    }
}

