/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.user.User;
import io.atlassian.util.concurrent.Lazy;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ViewUserDetailsAdminAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ViewUserDetailsAdminAction.class);
    private String username;
    @Inject
    private CrowdService crowdService;
    @Inject
    private CrowdDirectoryService directoryService;
    @Inject
    private LoginInformationManager loginInformationManager;
    private Supplier<BambooUser> user = Lazy.resettable(() -> this.bambooUserManager.getBambooUser(this.username));
    private Supplier<Directory> userDirectory = Lazy.resettable(() -> {
        long directoryId = this.crowdService.getUser(this.getUser().getName()).getDirectoryId();
        return this.directoryService.findDirectoryById(directoryId);
    });

    public String resetCaptcha() {
        if (StringUtils.isBlank((CharSequence)this.username)) {
            this.addActionError(this.getText("user.name.required"));
            return "error";
        }
        this.loginInformationManager.resetFailedLoginAttemptsCount(this.username);
        return "success";
    }

    public String execute() throws Exception {
        BambooUser user = this.getUser();
        if (user == null) {
            this.addActionError(this.getText("user.not.exists"));
            return "error";
        }
        return super.execute();
    }

    public String delete() {
        if (this.getUser() != null) {
            if (this.getUser().equals(this.authenticationContext.getUser())) {
                this.addActionError(this.getText("user.admin.error.removingSelf"));
            }
            if (!this.canDelete()) {
                this.addActionError(this.getText("user.admin.error.notDeletable"));
            }
        }
        if (this.hasFieldErrors() || this.hasActionErrors()) {
            return "error";
        }
        try {
            this.getBambooUserManager().removeUser((User)this.getUser());
            return "success";
        }
        catch (InfrastructureException e) {
            log.debug((Object)"User deletion failed", (Throwable)e);
            this.addActionError(this.getText("user.admin.error.notDeletable"));
            return "error";
        }
        catch (Exception e) {
            return this.handleGenericError(e);
        }
    }

    private String handleGenericError(Exception e) {
        log.debug((Object)"User deletion failed", (Throwable)e);
        this.addActionError(this.getText("user.admin.delete.error.generic", e.getMessage()));
        return "error";
    }

    public BambooUser getUser() {
        if (StringUtils.isBlank((CharSequence)this.username)) {
            this.addActionError(this.getText("user.name.required"));
            return null;
        }
        return this.user.get();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean canDelete() {
        return this.bambooUserManager.isDeletable((User)this.getUser());
    }

    public boolean canEdit() {
        return !this.bambooUserManager.isReadOnly((User)this.getUser());
    }

    public boolean isCaptchaEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getCaptchaConfiguration().isEnableCaptcha();
    }

    public boolean isCaptchaResetable() {
        return this.isCaptchaEnabled() && this.loginInformationManager.getFailedLoginAttemptsCount(this.username) > 0;
    }

    public String getCaptchaCount() {
        int failedCount = this.loginInformationManager.getFailedLoginAttemptsCount(this.username);
        int allowedFailures = this.administrationConfigurationAccessor.getAdministrationConfiguration().getCaptchaConfiguration().getMaxLoginAttempts();
        return this.getText("user.admin.edit.failedCaptchaAttempts", Arrays.asList(failedCount, allowedFailures));
    }

    public boolean isEnabled() {
        return this.getUser().isEnabled();
    }

    public String getFullName() {
        return this.getUser().getFullName();
    }

    public String getEmail() {
        return this.getUser().getEmail();
    }

    public String getJabberAddress() {
        return this.getUser().getJabberAddress();
    }

    public String getUserDirectory() {
        return this.userDirectory.get().getName();
    }

    public boolean isActive() {
        return this.getUser().isEnabled();
    }
}

