/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.util.BambooIterablesUtils;
import com.atlassian.bamboo.ww2.actions.admin.user.AbstractEntityPagerSupport;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.AllRepositoriesQueryContext;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.MultiTermBooleanQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UserQuery;
import com.google.common.collect.Ordering;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchUserAction
extends AbstractEntityPagerSupport {
    @Autowired
    private ExtendedAuthorManager extendedAuthorManager;
    private String affectedUsername;
    private String usernameTerm;
    private String fullnameTerm;
    private String emailTerm;

    public String browse() {
        Pager pager = this.getBambooUserManager().getUsers();
        this.getPaginationSupport().setItems(pager);
        return "input";
    }

    public String search() throws Exception {
        ArrayList<UserQuery> searchTerms = new ArrayList<UserQuery>();
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.usernameTerm)) {
                this.usernameTerm = this.appendWildcard(this.usernameTerm);
                searchTerms.add(this.getTermQuery(UserNameTermQuery.class, this.usernameTerm));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.fullnameTerm)) {
                this.fullnameTerm = this.appendWildcard(this.fullnameTerm);
                searchTerms.add(this.getTermQuery(FullNameTermQuery.class, this.fullnameTerm));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.emailTerm)) {
                this.emailTerm = this.appendWildcard(this.emailTerm);
                searchTerms.add(this.getTermQuery(EmailTermQuery.class, this.emailTerm));
            }
            if (searchTerms.isEmpty()) {
                searchTerms.add(this.getTermQuery(UserNameTermQuery.class, "*"));
            }
        }
        catch (EntityQueryException e) {
            this.addActionError((Exception)((Object)e));
            return "error";
        }
        if (!searchTerms.isEmpty()) {
            Query<User> userSearchQ = this.createUserQuery(searchTerms);
            AllRepositoriesQueryContext ctx = new AllRepositoriesQueryContext();
            SearchResult result = this.getBambooUserManager().findUsers(userSearchQ, (QueryContext)ctx);
            this.paginationSupport.setItems(result.pager());
        }
        return "success";
    }

    public Iterable<Group> getGroups(User user) {
        Pager groups = this.getBambooUserManager().getGroups(user);
        if (groups != null) {
            Iterable iterableGroups = BambooIterablesUtils.toIterable((Iterator)groups.iterator());
            return Ordering.usingToString().sortedCopy(iterableGroups);
        }
        return null;
    }

    public List<ExtendedAuthor> getLinkedAuthorsForUser(User user) {
        return this.extendedAuthorManager.getLinkedAuthorForUser(user);
    }

    private String appendWildcard(String s) {
        if (!s.endsWith("*")) {
            s = s + "*";
        }
        return s;
    }

    public Query<User> createUserQuery(List<UserQuery> searchTerms) {
        if (searchTerms.size() > 1) {
            return MultiTermBooleanQuery.allOf((Query[])((Query[])searchTerms.toArray(new UserQuery[0])));
        }
        return (Query)searchTerms.get(0);
    }

    public UserQuery getTermQuery(Class<? extends UserQuery> termQueryClass, String term) throws EntityQueryException {
        if (!term.contains("*")) {
            return this.getTermQueryObject(termQueryClass, term);
        }
        if (term.indexOf("*") == 0 && term.lastIndexOf("*") == 0) {
            String copied = term.replaceFirst("\\*", "");
            return this.getTermQueryObject(termQueryClass, copied, "ends_with");
        }
        if (term.indexOf("*") == term.length() - 1) {
            String copied = term.replaceFirst("\\*", "");
            return this.getTermQueryObject(termQueryClass, copied, "starts_with");
        }
        if (term.indexOf("*") == 0 && term.indexOf("*", 1) == term.length() - 1) {
            String copied = term.replaceAll("\\*", "");
            return this.getTermQueryObject(termQueryClass, copied, "contains");
        }
        throw new EntityQueryException("You may only use two wildcards to wrap the search term - e.g. *smith*. Your term was: " + term);
    }

    private UserQuery getTermQueryObject(Class<? extends UserQuery> termQueryClass, String term) throws EntityQueryException {
        try {
            Constructor<? extends UserQuery> constructor = termQueryClass.getConstructor(String.class);
            return constructor.newInstance(term);
        }
        catch (Exception e) {
            throw new EntityQueryException((Throwable)e);
        }
    }

    private UserQuery getTermQueryObject(Class<? extends UserQuery> termQueryClass, String term, String condition) throws EntityQueryException {
        try {
            Constructor<? extends UserQuery> constructor = termQueryClass.getConstructor(String.class, String.class);
            return constructor.newInstance(term, condition);
        }
        catch (Exception e) {
            throw new EntityQueryException((Throwable)e);
        }
    }

    public String getAffectedUsername() {
        return this.affectedUsername;
    }

    public void setAffectedUsername(String affectedUsername) {
        this.affectedUsername = affectedUsername;
    }

    public String getUsernameTerm() {
        return this.usernameTerm;
    }

    public void setUsernameTerm(String usernameTerm) {
        this.usernameTerm = usernameTerm;
    }

    public String getFullnameTerm() {
        return this.fullnameTerm;
    }

    public void setFullnameTerm(String fullnameTerm) {
        this.fullnameTerm = fullnameTerm;
    }

    public String getEmailTerm() {
        return this.emailTerm;
    }

    public void setEmailTerm(String emailTerm) {
        this.emailTerm = emailTerm;
    }
}

