/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.module.propertyset.PropertySet;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigureUser
extends BambooActionSupport {
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final int MAX_FULL_NAME_LENGTH = 255;
    private static final int MAX_EMAIL_LENGTH = 255;
    private static final String EDIT_MODE = "edit";
    private static final String ADD_MODE = "add";
    private String username;
    private String password;
    private String confirmPassword;
    private String fullName;
    private String email;
    private boolean enabled;
    private boolean changePassword;
    private String jabberAddress;
    private Supplier<BambooUser> currentUserSupplier = Lazy.resettable(() -> this.bambooUserManager.getBambooUser(this.username));
    private String mode = "add";
    @Inject
    private BambooTransactionHibernateTemplate hibernateTemplate;
    @Inject
    private ExtendedAuthorManager extendedAuthorManager;
    @Inject
    private CrowdService crowdService;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;

    public void validate() {
        if (ADD_MODE.equals(this.mode)) {
            if (this.canAddUser()) {
                return;
            }
            this.validateUsername();
            this.validatePassword();
            this.validateName();
            this.validateEmail();
        } else if (EDIT_MODE.equals(this.mode)) {
            BambooUser bambooUser = this.getCurrentUser();
            if (bambooUser == null) {
                this.addActionError("Could not edit user " + this.username + ", user could not be found.");
                return;
            }
            this.validateName();
            this.validateEmail();
            if (this.changePassword) {
                if (StringUtils.isBlank((CharSequence)this.password)) {
                    this.addFieldError("password", this.getText("user.password.error.required"));
                }
                this.validatePassword();
            }
        }
    }

    private boolean canEditUser(BambooUser bambooUser) {
        if (this.bambooUserManager.isReadOnly((User)bambooUser)) {
            this.addActionError("user.admin.edit.read.only.permissions");
            return true;
        }
        return false;
    }

    private boolean canAddUser() {
        if (!this.canCreateUsers()) {
            this.addActionError("user.admin.no.create.directory.permissions");
            return false;
        }
        return true;
    }

    private void validatePassword() {
        if (!StringUtils.isEmpty((CharSequence)this.password) && StringUtils.isBlank((CharSequence)this.password)) {
            this.addFieldError("password", this.getText("user.password.error.invalid"));
        }
        if (!this.password.equals(this.confirmPassword)) {
            this.addFieldError("confirmPassword", this.getText("user.password.change.new.confirm.invalid"));
        }
    }

    private void validateName() {
        if (!StringUtils.isEmpty((CharSequence)this.fullName) && StringUtils.isBlank((CharSequence)this.fullName) || IdentifierUtils.hasLeadingOrTrailingWhitespace((String)this.fullName) || this.fullName.length() > 255) {
            this.addFieldError("fullName", this.getText("user.fullName.error.required"));
        }
    }

    private void validateEmail() {
        if (!EmailValidator.isValidEmailAddressFormat((String)this.email) || this.email.length() > 255) {
            this.addFieldError("email", this.getText("user.email.error.invalid"));
        }
    }

    private void validateUsername() {
        if (!StringUtils.isEmpty((CharSequence)this.username) && StringUtils.isBlank((CharSequence)this.username) || IdentifierUtils.hasLeadingOrTrailingWhitespace((String)this.username) || this.username.length() > 255) {
            this.addFieldError("username", this.getText("user.username.error.invalid"));
        }
    }

    public String execute() throws Exception {
        switch (this.mode) {
            case "add": {
                return this.addUser();
            }
            case "edit": {
                return this.editUser();
            }
        }
        this.addActionError(this.getText("user.admin.unknown.mode.type", Collections.singletonList(this.mode)));
        return "error";
    }

    private String editUser() {
        return (String)this.hibernateTemplate.execute(transactionStatus -> {
            if (this.bambooUserManager.getBambooUser(this.username) == null) {
                this.addFieldError("username", this.getText("user.admin.edit.failed", Collections.singletonList(this.username)));
                return "error";
            }
            BambooUser currentUser = this.getCurrentUser();
            if (this.bambooUserManager.isReadOnly((User)currentUser)) {
                PropertySet propertySet = this.bambooUserManager.getPropertySet((User)currentUser);
                if (this.jabberAddress != null) {
                    propertySet.setString("bamboo.user.contact.jabber", this.jabberAddress);
                }
            } else {
                this.bambooUserManager.saveUser(this.username, this.changePassword ? this.password : null, this.enabled, this.email, this.fullName, this.jabberAddress, null, null, this.bambooUserManager.getGroupNamesAsList((User)currentUser), this.extendedAuthorManager.getLinkedAuthorForUser((User)currentUser).stream().map(BambooIdProvider::getId).collect(Collectors.toList()));
            }
            return "success";
        });
    }

    private String addUser() {
        return (String)this.hibernateTemplate.execute(transactionStatus -> {
            if (!this.canAddUser()) {
                return "error";
            }
            if (this.bambooUserManager.getBambooUser(this.username) != null) {
                this.addFieldError("username", "user.username.error.duplicate");
                return "error";
            }
            this.bambooUserManager.addUser(this.username, this.password, true, this.email, this.fullName, this.jabberAddress, Collections.emptyList(), Collections.emptyList());
            return "success";
        });
    }

    public String edit() throws Exception {
        if (this.getCurrentUser() != null) {
            this.enabled = this.getCurrentUser().isEnabled();
            this.email = this.getCurrentUser().getEmail();
            this.fullName = this.getCurrentUser().getFullName();
            this.jabberAddress = this.getCurrentUser().getJabberAddress();
        }
        return "input";
    }

    public Iterator getUsers() {
        Pager users = this.bambooUserManager.getUsers();
        return users.iterator();
    }

    public boolean isPasswordEditable() {
        return Optional.ofNullable(this.mode).filter(EDIT_MODE::equals).map(any -> this.crowdService.getUser(this.username)).map(user -> this.crowdDirectoryService.findDirectoryById(user.getDirectoryId())).map(directory -> DirectoryType.DELEGATING != directory.getType()).orElse(true);
    }

    @Nullable
    public BambooUser getCurrentUser() {
        return this.currentUserSupplier.get();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public boolean isChangePassword() {
        return this.changePassword;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getJabberAddress() {
        return this.jabberAddress;
    }

    public void setJabberAddress(String jabberAddress) {
        this.jabberAddress = jabberAddress;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean canCreateUsers() {
        return this.bambooUserManager.canCreateUsers();
    }
}

