/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.user.UserAdministrationUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureProfile
extends BambooActionSupport {
    private String password;
    private String confirmPassword;
    private String fullName;
    private String email;
    private List<Long> authors = new ArrayList<Long>();
    private String jabberAddress;
    private String notificationPreference;
    private String notificationTransportPreference;
    BambooUser currentUser;
    private List<ExtendedAuthor> availableAuthors;
    private List<ExtendedAuthor> repositoryAliases;
    private String currentUserName;
    private List<String> groups;
    @Autowired
    private ExtendedAuthorManager extendedAuthorManager;

    public String update() throws Exception {
        return this.execute();
    }

    public String edit() throws Exception {
        if (this.isCurrentlyLoggedInUser()) {
            return this.doDefault();
        }
        if (this.getUser() == null) {
            return "login";
        }
        this.addActionError("You do not have permission to edit the profile of this user");
        return "error";
    }

    @Override
    public String doDefault() throws Exception {
        if (this.isCurrentlyLoggedInUser() && this.getCurrentUser() != null) {
            this.email = this.getCurrentUser().getEmail();
            this.fullName = this.getCurrentUser().getFullName();
            this.jabberAddress = this.getCurrentUser().getJabberAddress();
            this.groups = this.getBambooUserManager().getGroupNamesAsList(this.getCurrentUser().getUser());
            this.notificationPreference = this.getCurrentUser().getNotificationPreference();
            this.notificationTransportPreference = this.getCurrentUser().getNotificationTransportPreference();
            this.authors = Lists.newArrayList((Iterable)Iterables.transform(this.getRepositoryAliases(), (Function)BambooFunctions.getBambooObjectId()));
            return "input";
        }
        if (this.getUser() == null) {
            return "login";
        }
        this.addActionError("You do not have permission to view the profile of this user");
        return "error";
    }

    public void validate() {
    }

    public String execute() throws Exception {
        if (!this.isCurrentlyLoggedInUser()) {
            this.addActionError("You do not have permission to edit the profile of this user");
            return "error";
        }
        if (this.getCurrentUser() != null) {
            List groups = this.getBambooUserManager().getGroupNamesAsList(this.getCurrentUser().getUser());
            String username = this.getCurrentUser().getUser().getName();
            try {
                this.bambooUserManager.saveUser(username, null, this.getCurrentUser().isEnabled(), this.getCurrentUser().getUser().getEmail(), this.fullName, this.jabberAddress, null, null, groups, this.authors);
                return "success";
            }
            catch (InfrastructureException e) {
                UserAdministrationUtils.processInfrastructureExceptionForCrowdException(e, this);
                return "error";
            }
        }
        this.addActionError(this.getText("user.admin.edit.failed", new String[]{this.currentUserName}));
        return "error";
    }

    public boolean isCurrentlyLoggedInUser() {
        if (this.getUser() == null || this.getCurrentUser() == null || this.getCurrentUser().getUser() == null) {
            return false;
        }
        return this.getCurrentUser().getUser().equals(this.getUser());
    }

    public BambooUser getCurrentUser() {
        if (this.currentUser == null) {
            if (StringUtils.isBlank((CharSequence)this.currentUserName)) {
                User user = this.getUser();
                if (user != null) {
                    this.currentUser = this.getBambooUserManager().getBambooUser(user.getName());
                }
            } else {
                this.currentUser = this.getBambooUserManager().getBambooUser(this.currentUserName);
            }
        }
        return this.currentUser;
    }

    public List<ExtendedAuthor> getRepositoryAliases() {
        if (this.repositoryAliases == null) {
            this.repositoryAliases = this.extendedAuthorManager.getLinkedAuthorForUser(this.getCurrentUser().getUser());
        }
        return this.repositoryAliases;
    }

    public List<ExtendedAuthor> getAvailableAuthors() {
        if (this.availableAuthors == null) {
            BambooUser user = this.getCurrentUser();
            this.availableAuthors = this.extendedAuthorManager.getAvailableAuthors(user != null ? user.getUser() : null);
        }
        return this.availableAuthors;
    }

    public boolean isUserReadOnly(User user) {
        return this.getBambooUserManager().isReadOnly(user);
    }

    public String getEncodedCurrentUrl() {
        String myUrl = this.getCurrentUrl();
        return EscapeChars.forUrl((String)myUrl);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getJabberAddress() {
        return this.jabberAddress;
    }

    public void setJabberAddress(String jabberAddress) {
        this.jabberAddress = jabberAddress;
    }

    public List<Long> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors != null ? Lists.newArrayList((Iterable)Iterables.transform(authors, Long::valueOf)) : Collections.emptyList();
    }

    public String getNotificationPreference() {
        return this.notificationPreference;
    }

    public void setNotificationPreference(String notificationPreference) {
        this.notificationPreference = notificationPreference;
    }

    public String getNotificationTransportPreference() {
        return this.notificationTransportPreference;
    }

    public void setNotificationTransportPreference(String notificationTransportPreference) {
        this.notificationTransportPreference = notificationTransportPreference;
    }
}

