/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.UsersNotification;
import com.atlassian.bamboo.ww2.actions.admin.user.ConfigureProfile;
import com.atlassian.bamboo.ww2.actions.admin.user.UserAdministrationUtils;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfigureNotificationPreferences
extends ConfigureProfile {
    private static final Logger log = Logger.getLogger(ConfigureNotificationPreferences.class);
    private List<UsersNotification> usersRules;
    private InstantMessagingServerManager instantMessagingServerManager;
    private NotificationManager notificationManager;

    @Override
    public String execute() throws Exception {
        if (!this.isCurrentlyLoggedInUser()) {
            this.addActionError("You do not have permission to edit the profile of this user");
            return "error";
        }
        if (this.getCurrentUser() != null) {
            String username = this.getCurrentUser().getUser().getName();
            try {
                this.getBambooUserManager().saveNotificationPreferences(username, this.getNotificationPreference(), this.getNotificationTransportPreference());
                return "success";
            }
            catch (InfrastructureException e) {
                UserAdministrationUtils.processInfrastructureExceptionForCrowdException(e, this);
                return "error";
            }
        }
        this.addActionError(this.getText("user.admin.edit.failed", new String[]{this.getCurrentUserName()}));
        return "error";
    }

    public List<UsersNotification> getUsersNotificationRules() {
        if (this.usersRules == null && this.getCurrentUser() != null) {
            this.usersRules = this.notificationManager.getNotificationRulesForUser(this.getCurrentUser());
        }
        return this.usersRules;
    }

    public boolean isRecipientUserBased(NotificationRule notificationRule) {
        return this.notificationManager.isRecipientUserBase(notificationRule);
    }

    public String getNotificationErrorMessageKey() {
        if ("im".equals(this.getNotificationPreference())) {
            if (!this.isJabberServerConfigured() && this.isMailServerConfigured()) {
                return "user.notification.preference.error.noimserver";
            }
            if (this.isJabberServerConfigured() && StringUtils.isBlank((CharSequence)this.getJabberAddress())) {
                return "user.notification.preference.error.nojabberaddress";
            }
        } else if ("textEmail".equals(this.getNotificationPreference())) {
            if (this.isJabberServerConfigured() && !this.isMailServerConfigured()) {
                return "user.notification.preference.error.nomailserver";
            }
            if (this.isMailServerConfigured() && StringUtils.isBlank((CharSequence)this.getEmail())) {
                return "user.notification.preference.error.noemailaddress";
            }
        } else if ("both".equals(this.getNotificationPreference())) {
            if (!this.isJabberServerConfigured()) {
                if (!this.isMailServerConfigured()) {
                    return "notification.both.notConfigured";
                }
                if (StringUtils.isBlank((CharSequence)this.getEmail())) {
                    return "user.notification.preference.error.noimservernoemailaddress";
                }
                return "notification.im.notConfigured";
            }
            if (!this.isMailServerConfigured()) {
                if (StringUtils.isBlank((CharSequence)this.getJabberAddress())) {
                    return "user.notification.preference.error.nomailservernojabberaddress";
                }
                return "notification.mail.notConfigured";
            }
            if (StringUtils.isBlank((CharSequence)this.getEmail())) {
                if (StringUtils.isBlank((CharSequence)this.getJabberAddress())) {
                    return "user.notification.preference.error.noemailandjabberaddress";
                }
                return "user.notification.preference.error.jabberbutnoemailaddress";
            }
            if (StringUtils.isBlank((CharSequence)this.getJabberAddress())) {
                return "user.notification.preference.error.emailbutnojabberaddress";
            }
        }
        return null;
    }

    public String getNotificationAddServerKey() {
        if (!this.isJabberServerConfigured()) {
            if (!this.isMailServerConfigured()) {
                return "notification.both.add";
            }
            return "notification.im.add";
        }
        if (!this.isMailServerConfigured()) {
            return "notification.mail.add";
        }
        return null;
    }

    private boolean isMailServerConfigured() {
        return this.getMailServerManager().isDefaultSMTPMailServerDefined();
    }

    private MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    private boolean isJabberServerConfigured() {
        Collection instantMessagingServers = this.instantMessagingServerManager.getAllInstantMessagingServers();
        return !instantMessagingServers.isEmpty();
    }

    public Map<String, String> getNotificationTypes() {
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        types.put("none", "Do not send notifications");
        types.put("im", "Send instant message");
        types.put("textEmail", "Send email");
        types.put("both", "Send email and instant message");
        return types;
    }

    public Map<String, String> getNotificationTransportPreferenceTypes() {
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        types.put("text", "Text email");
        types.put("multipart", "HTML email (multipart)");
        return types;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setInstantMessagingServerManager(InstantMessagingServerManager instantMessagingServerManager) {
        this.instantMessagingServerManager = instantMessagingServerManager;
    }
}

