/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.admin.user;

import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfigureAlias
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ConfigureAlias.class);
    private String newAuthorName;
    private ExtendedAuthorManager extendedAuthorManager;

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.newAuthorName)) {
            this.addFieldError("newAuthorName", this.getText("user.repositoryAlias.add.blank"));
        } else if (this.extendedAuthorManager.getExtendedAuthorByName(this.newAuthorName) != null) {
            this.addFieldError("newAuthorName", this.getText("user.repositoryAlias.add.unique"));
        }
    }

    public String execute() throws Exception {
        AuthorImpl newAuthor = new AuthorImpl(this.newAuthorName);
        this.extendedAuthorManager.saveAuthor((ExtendedAuthor)newAuthor);
        this.getJsonObject().put("aliasName", (Object)this.newAuthorName).put("aliasId", newAuthor.getId());
        return "success";
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    public String getNewAuthorName() {
        return this.newAuthorName;
    }

    public void setNewAuthorName(String newAuthorName) {
        this.newAuthorName = newAuthorName;
    }
}

